/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.rds.model.CreateDBInstanceRequest;
import com.amazonaws.services.rds.model.Tag;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class CreateDBInstanceRequestMarshaller
implements Marshaller<Request<CreateDBInstanceRequest>, CreateDBInstanceRequest> {
    public Request<CreateDBInstanceRequest> marshall(CreateDBInstanceRequest createDBInstanceRequest) {
        SdkInternalList tagsList;
        SdkInternalList vpcSecurityGroupIdsList;
        SdkInternalList dBSecurityGroupsList;
        if (createDBInstanceRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createDBInstanceRequest, "AmazonRDS");
        request.addParameter("Action", "CreateDBInstance");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (createDBInstanceRequest.getDBName() != null) {
            request.addParameter("DBName", StringUtils.fromString((String)createDBInstanceRequest.getDBName()));
        }
        if (createDBInstanceRequest.getDBInstanceIdentifier() != null) {
            request.addParameter("DBInstanceIdentifier", StringUtils.fromString((String)createDBInstanceRequest.getDBInstanceIdentifier()));
        }
        if (createDBInstanceRequest.getAllocatedStorage() != null) {
            request.addParameter("AllocatedStorage", StringUtils.fromInteger((Integer)createDBInstanceRequest.getAllocatedStorage()));
        }
        if (createDBInstanceRequest.getDBInstanceClass() != null) {
            request.addParameter("DBInstanceClass", StringUtils.fromString((String)createDBInstanceRequest.getDBInstanceClass()));
        }
        if (createDBInstanceRequest.getEngine() != null) {
            request.addParameter("Engine", StringUtils.fromString((String)createDBInstanceRequest.getEngine()));
        }
        if (createDBInstanceRequest.getMasterUsername() != null) {
            request.addParameter("MasterUsername", StringUtils.fromString((String)createDBInstanceRequest.getMasterUsername()));
        }
        if (createDBInstanceRequest.getMasterUserPassword() != null) {
            request.addParameter("MasterUserPassword", StringUtils.fromString((String)createDBInstanceRequest.getMasterUserPassword()));
        }
        if (!(dBSecurityGroupsList = (SdkInternalList)createDBInstanceRequest.getDBSecurityGroups()).isEmpty() || !dBSecurityGroupsList.isAutoConstruct()) {
            int dBSecurityGroupsListIndex = 1;
            for (Object dBSecurityGroupsListValue : dBSecurityGroupsList) {
                if (dBSecurityGroupsListValue != null) {
                    request.addParameter("DBSecurityGroups.DBSecurityGroupName." + dBSecurityGroupsListIndex, StringUtils.fromString((String)dBSecurityGroupsListValue));
                }
                ++dBSecurityGroupsListIndex;
            }
        }
        if (!(vpcSecurityGroupIdsList = (SdkInternalList)createDBInstanceRequest.getVpcSecurityGroupIds()).isEmpty() || !vpcSecurityGroupIdsList.isAutoConstruct()) {
            int vpcSecurityGroupIdsListIndex = 1;
            for (String vpcSecurityGroupIdsListValue : vpcSecurityGroupIdsList) {
                if (vpcSecurityGroupIdsListValue != null) {
                    request.addParameter("VpcSecurityGroupIds.VpcSecurityGroupId." + vpcSecurityGroupIdsListIndex, StringUtils.fromString((String)vpcSecurityGroupIdsListValue));
                }
                ++vpcSecurityGroupIdsListIndex;
            }
        }
        if (createDBInstanceRequest.getAvailabilityZone() != null) {
            request.addParameter("AvailabilityZone", StringUtils.fromString((String)createDBInstanceRequest.getAvailabilityZone()));
        }
        if (createDBInstanceRequest.getDBSubnetGroupName() != null) {
            request.addParameter("DBSubnetGroupName", StringUtils.fromString((String)createDBInstanceRequest.getDBSubnetGroupName()));
        }
        if (createDBInstanceRequest.getPreferredMaintenanceWindow() != null) {
            request.addParameter("PreferredMaintenanceWindow", StringUtils.fromString((String)createDBInstanceRequest.getPreferredMaintenanceWindow()));
        }
        if (createDBInstanceRequest.getDBParameterGroupName() != null) {
            request.addParameter("DBParameterGroupName", StringUtils.fromString((String)createDBInstanceRequest.getDBParameterGroupName()));
        }
        if (createDBInstanceRequest.getBackupRetentionPeriod() != null) {
            request.addParameter("BackupRetentionPeriod", StringUtils.fromInteger((Integer)createDBInstanceRequest.getBackupRetentionPeriod()));
        }
        if (createDBInstanceRequest.getPreferredBackupWindow() != null) {
            request.addParameter("PreferredBackupWindow", StringUtils.fromString((String)createDBInstanceRequest.getPreferredBackupWindow()));
        }
        if (createDBInstanceRequest.getPort() != null) {
            request.addParameter("Port", StringUtils.fromInteger((Integer)createDBInstanceRequest.getPort()));
        }
        if (createDBInstanceRequest.getMultiAZ() != null) {
            request.addParameter("MultiAZ", StringUtils.fromBoolean((Boolean)createDBInstanceRequest.getMultiAZ()));
        }
        if (createDBInstanceRequest.getEngineVersion() != null) {
            request.addParameter("EngineVersion", StringUtils.fromString((String)createDBInstanceRequest.getEngineVersion()));
        }
        if (createDBInstanceRequest.getAutoMinorVersionUpgrade() != null) {
            request.addParameter("AutoMinorVersionUpgrade", StringUtils.fromBoolean((Boolean)createDBInstanceRequest.getAutoMinorVersionUpgrade()));
        }
        if (createDBInstanceRequest.getLicenseModel() != null) {
            request.addParameter("LicenseModel", StringUtils.fromString((String)createDBInstanceRequest.getLicenseModel()));
        }
        if (createDBInstanceRequest.getIops() != null) {
            request.addParameter("Iops", StringUtils.fromInteger((Integer)createDBInstanceRequest.getIops()));
        }
        if (createDBInstanceRequest.getOptionGroupName() != null) {
            request.addParameter("OptionGroupName", StringUtils.fromString((String)createDBInstanceRequest.getOptionGroupName()));
        }
        if (createDBInstanceRequest.getCharacterSetName() != null) {
            request.addParameter("CharacterSetName", StringUtils.fromString((String)createDBInstanceRequest.getCharacterSetName()));
        }
        if (createDBInstanceRequest.getPubliclyAccessible() != null) {
            request.addParameter("PubliclyAccessible", StringUtils.fromBoolean((Boolean)createDBInstanceRequest.getPubliclyAccessible()));
        }
        if (!(tagsList = (SdkInternalList)createDBInstanceRequest.getTags()).isEmpty() || !tagsList.isAutoConstruct()) {
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue.getKey() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Key", StringUtils.fromString((String)tagsListValue.getKey()));
                }
                if (tagsListValue.getValue() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Value", StringUtils.fromString((String)tagsListValue.getValue()));
                }
                ++tagsListIndex;
            }
        }
        if (createDBInstanceRequest.getDBClusterIdentifier() != null) {
            request.addParameter("DBClusterIdentifier", StringUtils.fromString((String)createDBInstanceRequest.getDBClusterIdentifier()));
        }
        if (createDBInstanceRequest.getStorageType() != null) {
            request.addParameter("StorageType", StringUtils.fromString((String)createDBInstanceRequest.getStorageType()));
        }
        if (createDBInstanceRequest.getTdeCredentialArn() != null) {
            request.addParameter("TdeCredentialArn", StringUtils.fromString((String)createDBInstanceRequest.getTdeCredentialArn()));
        }
        if (createDBInstanceRequest.getTdeCredentialPassword() != null) {
            request.addParameter("TdeCredentialPassword", StringUtils.fromString((String)createDBInstanceRequest.getTdeCredentialPassword()));
        }
        if (createDBInstanceRequest.getStorageEncrypted() != null) {
            request.addParameter("StorageEncrypted", StringUtils.fromBoolean((Boolean)createDBInstanceRequest.getStorageEncrypted()));
        }
        if (createDBInstanceRequest.getKmsKeyId() != null) {
            request.addParameter("KmsKeyId", StringUtils.fromString((String)createDBInstanceRequest.getKmsKeyId()));
        }
        if (createDBInstanceRequest.getDomain() != null) {
            request.addParameter("Domain", StringUtils.fromString((String)createDBInstanceRequest.getDomain()));
        }
        if (createDBInstanceRequest.getCopyTagsToSnapshot() != null) {
            request.addParameter("CopyTagsToSnapshot", StringUtils.fromBoolean((Boolean)createDBInstanceRequest.getCopyTagsToSnapshot()));
        }
        if (createDBInstanceRequest.getMonitoringInterval() != null) {
            request.addParameter("MonitoringInterval", StringUtils.fromInteger((Integer)createDBInstanceRequest.getMonitoringInterval()));
        }
        if (createDBInstanceRequest.getMonitoringRoleArn() != null) {
            request.addParameter("MonitoringRoleArn", StringUtils.fromString((String)createDBInstanceRequest.getMonitoringRoleArn()));
        }
        if (createDBInstanceRequest.getDomainIAMRoleName() != null) {
            request.addParameter("DomainIAMRoleName", StringUtils.fromString((String)createDBInstanceRequest.getDomainIAMRoleName()));
        }
        if (createDBInstanceRequest.getPromotionTier() != null) {
            request.addParameter("PromotionTier", StringUtils.fromInteger((Integer)createDBInstanceRequest.getPromotionTier()));
        }
        if (createDBInstanceRequest.getTimezone() != null) {
            request.addParameter("Timezone", StringUtils.fromString((String)createDBInstanceRequest.getTimezone()));
        }
        if (createDBInstanceRequest.getEnableIAMDatabaseAuthentication() != null) {
            request.addParameter("EnableIAMDatabaseAuthentication", StringUtils.fromBoolean((Boolean)createDBInstanceRequest.getEnableIAMDatabaseAuthentication()));
        }
        return request;
    }
}

