/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.rds.model.DescribeDBClusterBacktracksRequest;
import com.amazonaws.services.rds.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeDBClusterBacktracksRequestMarshaller
implements Marshaller<Request<DescribeDBClusterBacktracksRequest>, DescribeDBClusterBacktracksRequest> {
    public Request<DescribeDBClusterBacktracksRequest> marshall(DescribeDBClusterBacktracksRequest describeDBClusterBacktracksRequest) {
        if (describeDBClusterBacktracksRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeDBClusterBacktracksRequest, "AmazonRDS");
        request.addParameter("Action", "DescribeDBClusterBacktracks");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeDBClusterBacktracksRequest.getDBClusterIdentifier() != null) {
            request.addParameter("DBClusterIdentifier", StringUtils.fromString((String)describeDBClusterBacktracksRequest.getDBClusterIdentifier()));
        }
        if (describeDBClusterBacktracksRequest.getBacktrackIdentifier() != null) {
            request.addParameter("BacktrackIdentifier", StringUtils.fromString((String)describeDBClusterBacktracksRequest.getBacktrackIdentifier()));
        }
        if (!describeDBClusterBacktracksRequest.getFilters().isEmpty() || !((SdkInternalList)describeDBClusterBacktracksRequest.getFilters()).isAutoConstruct()) {
            SdkInternalList filtersList = (SdkInternalList)describeDBClusterBacktracksRequest.getFilters();
            int filtersListIndex = 1;
            for (Filter filtersListValue : filtersList) {
                if (filtersListValue != null) {
                    if (filtersListValue.getName() != null) {
                        request.addParameter("Filters.Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)filtersListValue.getName()));
                    }
                    if (!filtersListValue.getValues().isEmpty() || !((SdkInternalList)filtersListValue.getValues()).isAutoConstruct()) {
                        SdkInternalList valuesList = (SdkInternalList)filtersListValue.getValues();
                        int valuesListIndex = 1;
                        for (String valuesListValue : valuesList) {
                            if (valuesListValue != null) {
                                request.addParameter("Filters.Filter." + filtersListIndex + ".Values.Value." + valuesListIndex, StringUtils.fromString((String)valuesListValue));
                            }
                            ++valuesListIndex;
                        }
                    }
                }
                ++filtersListIndex;
            }
        }
        if (describeDBClusterBacktracksRequest.getMaxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger((Integer)describeDBClusterBacktracksRequest.getMaxRecords()));
        }
        if (describeDBClusterBacktracksRequest.getMarker() != null) {
            request.addParameter("Marker", StringUtils.fromString((String)describeDBClusterBacktracksRequest.getMarker()));
        }
        return request;
    }
}

