/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.rds.model.ProcessorFeature;
import com.amazonaws.services.rds.model.RestoreDBInstanceFromS3Request;
import com.amazonaws.services.rds.model.Tag;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class RestoreDBInstanceFromS3RequestMarshaller
implements Marshaller<Request<RestoreDBInstanceFromS3Request>, RestoreDBInstanceFromS3Request> {
    public Request<RestoreDBInstanceFromS3Request> marshall(RestoreDBInstanceFromS3Request restoreDBInstanceFromS3Request) {
        if (restoreDBInstanceFromS3Request == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)restoreDBInstanceFromS3Request, "AmazonRDS");
        request.addParameter("Action", "RestoreDBInstanceFromS3");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (restoreDBInstanceFromS3Request.getDBName() != null) {
            request.addParameter("DBName", StringUtils.fromString((String)restoreDBInstanceFromS3Request.getDBName()));
        }
        if (restoreDBInstanceFromS3Request.getDBInstanceIdentifier() != null) {
            request.addParameter("DBInstanceIdentifier", StringUtils.fromString((String)restoreDBInstanceFromS3Request.getDBInstanceIdentifier()));
        }
        if (restoreDBInstanceFromS3Request.getAllocatedStorage() != null) {
            request.addParameter("AllocatedStorage", StringUtils.fromInteger((Integer)restoreDBInstanceFromS3Request.getAllocatedStorage()));
        }
        if (restoreDBInstanceFromS3Request.getDBInstanceClass() != null) {
            request.addParameter("DBInstanceClass", StringUtils.fromString((String)restoreDBInstanceFromS3Request.getDBInstanceClass()));
        }
        if (restoreDBInstanceFromS3Request.getEngine() != null) {
            request.addParameter("Engine", StringUtils.fromString((String)restoreDBInstanceFromS3Request.getEngine()));
        }
        if (restoreDBInstanceFromS3Request.getMasterUsername() != null) {
            request.addParameter("MasterUsername", StringUtils.fromString((String)restoreDBInstanceFromS3Request.getMasterUsername()));
        }
        if (restoreDBInstanceFromS3Request.getMasterUserPassword() != null) {
            request.addParameter("MasterUserPassword", StringUtils.fromString((String)restoreDBInstanceFromS3Request.getMasterUserPassword()));
        }
        if (!restoreDBInstanceFromS3Request.getDBSecurityGroups().isEmpty() || !((SdkInternalList)restoreDBInstanceFromS3Request.getDBSecurityGroups()).isAutoConstruct()) {
            SdkInternalList dBSecurityGroupsList = (SdkInternalList)restoreDBInstanceFromS3Request.getDBSecurityGroups();
            int dBSecurityGroupsListIndex = 1;
            for (String dBSecurityGroupsListValue : dBSecurityGroupsList) {
                if (dBSecurityGroupsListValue != null) {
                    request.addParameter("DBSecurityGroups.DBSecurityGroupName." + dBSecurityGroupsListIndex, StringUtils.fromString((String)dBSecurityGroupsListValue));
                }
                ++dBSecurityGroupsListIndex;
            }
        }
        if (!restoreDBInstanceFromS3Request.getVpcSecurityGroupIds().isEmpty() || !((SdkInternalList)restoreDBInstanceFromS3Request.getVpcSecurityGroupIds()).isAutoConstruct()) {
            SdkInternalList vpcSecurityGroupIdsList = (SdkInternalList)restoreDBInstanceFromS3Request.getVpcSecurityGroupIds();
            int vpcSecurityGroupIdsListIndex = 1;
            for (String vpcSecurityGroupIdsListValue : vpcSecurityGroupIdsList) {
                if (vpcSecurityGroupIdsListValue != null) {
                    request.addParameter("VpcSecurityGroupIds.VpcSecurityGroupId." + vpcSecurityGroupIdsListIndex, StringUtils.fromString((String)vpcSecurityGroupIdsListValue));
                }
                ++vpcSecurityGroupIdsListIndex;
            }
        }
        if (restoreDBInstanceFromS3Request.getAvailabilityZone() != null) {
            request.addParameter("AvailabilityZone", StringUtils.fromString((String)restoreDBInstanceFromS3Request.getAvailabilityZone()));
        }
        if (restoreDBInstanceFromS3Request.getDBSubnetGroupName() != null) {
            request.addParameter("DBSubnetGroupName", StringUtils.fromString((String)restoreDBInstanceFromS3Request.getDBSubnetGroupName()));
        }
        if (restoreDBInstanceFromS3Request.getPreferredMaintenanceWindow() != null) {
            request.addParameter("PreferredMaintenanceWindow", StringUtils.fromString((String)restoreDBInstanceFromS3Request.getPreferredMaintenanceWindow()));
        }
        if (restoreDBInstanceFromS3Request.getDBParameterGroupName() != null) {
            request.addParameter("DBParameterGroupName", StringUtils.fromString((String)restoreDBInstanceFromS3Request.getDBParameterGroupName()));
        }
        if (restoreDBInstanceFromS3Request.getBackupRetentionPeriod() != null) {
            request.addParameter("BackupRetentionPeriod", StringUtils.fromInteger((Integer)restoreDBInstanceFromS3Request.getBackupRetentionPeriod()));
        }
        if (restoreDBInstanceFromS3Request.getPreferredBackupWindow() != null) {
            request.addParameter("PreferredBackupWindow", StringUtils.fromString((String)restoreDBInstanceFromS3Request.getPreferredBackupWindow()));
        }
        if (restoreDBInstanceFromS3Request.getPort() != null) {
            request.addParameter("Port", StringUtils.fromInteger((Integer)restoreDBInstanceFromS3Request.getPort()));
        }
        if (restoreDBInstanceFromS3Request.getMultiAZ() != null) {
            request.addParameter("MultiAZ", StringUtils.fromBoolean((Boolean)restoreDBInstanceFromS3Request.getMultiAZ()));
        }
        if (restoreDBInstanceFromS3Request.getEngineVersion() != null) {
            request.addParameter("EngineVersion", StringUtils.fromString((String)restoreDBInstanceFromS3Request.getEngineVersion()));
        }
        if (restoreDBInstanceFromS3Request.getAutoMinorVersionUpgrade() != null) {
            request.addParameter("AutoMinorVersionUpgrade", StringUtils.fromBoolean((Boolean)restoreDBInstanceFromS3Request.getAutoMinorVersionUpgrade()));
        }
        if (restoreDBInstanceFromS3Request.getLicenseModel() != null) {
            request.addParameter("LicenseModel", StringUtils.fromString((String)restoreDBInstanceFromS3Request.getLicenseModel()));
        }
        if (restoreDBInstanceFromS3Request.getIops() != null) {
            request.addParameter("Iops", StringUtils.fromInteger((Integer)restoreDBInstanceFromS3Request.getIops()));
        }
        if (restoreDBInstanceFromS3Request.getOptionGroupName() != null) {
            request.addParameter("OptionGroupName", StringUtils.fromString((String)restoreDBInstanceFromS3Request.getOptionGroupName()));
        }
        if (restoreDBInstanceFromS3Request.getPubliclyAccessible() != null) {
            request.addParameter("PubliclyAccessible", StringUtils.fromBoolean((Boolean)restoreDBInstanceFromS3Request.getPubliclyAccessible()));
        }
        if (!restoreDBInstanceFromS3Request.getTags().isEmpty() || !((SdkInternalList)restoreDBInstanceFromS3Request.getTags()).isAutoConstruct()) {
            SdkInternalList tagsList = (SdkInternalList)restoreDBInstanceFromS3Request.getTags();
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue != null) {
                    if (tagsListValue.getKey() != null) {
                        request.addParameter("Tags.Tag." + tagsListIndex + ".Key", StringUtils.fromString((String)tagsListValue.getKey()));
                    }
                    if (tagsListValue.getValue() != null) {
                        request.addParameter("Tags.Tag." + tagsListIndex + ".Value", StringUtils.fromString((String)tagsListValue.getValue()));
                    }
                }
                ++tagsListIndex;
            }
        }
        if (restoreDBInstanceFromS3Request.getStorageType() != null) {
            request.addParameter("StorageType", StringUtils.fromString((String)restoreDBInstanceFromS3Request.getStorageType()));
        }
        if (restoreDBInstanceFromS3Request.getStorageEncrypted() != null) {
            request.addParameter("StorageEncrypted", StringUtils.fromBoolean((Boolean)restoreDBInstanceFromS3Request.getStorageEncrypted()));
        }
        if (restoreDBInstanceFromS3Request.getKmsKeyId() != null) {
            request.addParameter("KmsKeyId", StringUtils.fromString((String)restoreDBInstanceFromS3Request.getKmsKeyId()));
        }
        if (restoreDBInstanceFromS3Request.getCopyTagsToSnapshot() != null) {
            request.addParameter("CopyTagsToSnapshot", StringUtils.fromBoolean((Boolean)restoreDBInstanceFromS3Request.getCopyTagsToSnapshot()));
        }
        if (restoreDBInstanceFromS3Request.getMonitoringInterval() != null) {
            request.addParameter("MonitoringInterval", StringUtils.fromInteger((Integer)restoreDBInstanceFromS3Request.getMonitoringInterval()));
        }
        if (restoreDBInstanceFromS3Request.getMonitoringRoleArn() != null) {
            request.addParameter("MonitoringRoleArn", StringUtils.fromString((String)restoreDBInstanceFromS3Request.getMonitoringRoleArn()));
        }
        if (restoreDBInstanceFromS3Request.getEnableIAMDatabaseAuthentication() != null) {
            request.addParameter("EnableIAMDatabaseAuthentication", StringUtils.fromBoolean((Boolean)restoreDBInstanceFromS3Request.getEnableIAMDatabaseAuthentication()));
        }
        if (restoreDBInstanceFromS3Request.getSourceEngine() != null) {
            request.addParameter("SourceEngine", StringUtils.fromString((String)restoreDBInstanceFromS3Request.getSourceEngine()));
        }
        if (restoreDBInstanceFromS3Request.getSourceEngineVersion() != null) {
            request.addParameter("SourceEngineVersion", StringUtils.fromString((String)restoreDBInstanceFromS3Request.getSourceEngineVersion()));
        }
        if (restoreDBInstanceFromS3Request.getS3BucketName() != null) {
            request.addParameter("S3BucketName", StringUtils.fromString((String)restoreDBInstanceFromS3Request.getS3BucketName()));
        }
        if (restoreDBInstanceFromS3Request.getS3Prefix() != null) {
            request.addParameter("S3Prefix", StringUtils.fromString((String)restoreDBInstanceFromS3Request.getS3Prefix()));
        }
        if (restoreDBInstanceFromS3Request.getS3IngestionRoleArn() != null) {
            request.addParameter("S3IngestionRoleArn", StringUtils.fromString((String)restoreDBInstanceFromS3Request.getS3IngestionRoleArn()));
        }
        if (restoreDBInstanceFromS3Request.getEnablePerformanceInsights() != null) {
            request.addParameter("EnablePerformanceInsights", StringUtils.fromBoolean((Boolean)restoreDBInstanceFromS3Request.getEnablePerformanceInsights()));
        }
        if (restoreDBInstanceFromS3Request.getPerformanceInsightsKMSKeyId() != null) {
            request.addParameter("PerformanceInsightsKMSKeyId", StringUtils.fromString((String)restoreDBInstanceFromS3Request.getPerformanceInsightsKMSKeyId()));
        }
        if (restoreDBInstanceFromS3Request.getPerformanceInsightsRetentionPeriod() != null) {
            request.addParameter("PerformanceInsightsRetentionPeriod", StringUtils.fromInteger((Integer)restoreDBInstanceFromS3Request.getPerformanceInsightsRetentionPeriod()));
        }
        if (!restoreDBInstanceFromS3Request.getEnableCloudwatchLogsExports().isEmpty() || !((SdkInternalList)restoreDBInstanceFromS3Request.getEnableCloudwatchLogsExports()).isAutoConstruct()) {
            SdkInternalList enableCloudwatchLogsExportsList = (SdkInternalList)restoreDBInstanceFromS3Request.getEnableCloudwatchLogsExports();
            int enableCloudwatchLogsExportsListIndex = 1;
            for (String enableCloudwatchLogsExportsListValue : enableCloudwatchLogsExportsList) {
                if (enableCloudwatchLogsExportsListValue != null) {
                    request.addParameter("EnableCloudwatchLogsExports.member." + enableCloudwatchLogsExportsListIndex, StringUtils.fromString((String)enableCloudwatchLogsExportsListValue));
                }
                ++enableCloudwatchLogsExportsListIndex;
            }
        }
        if (!restoreDBInstanceFromS3Request.getProcessorFeatures().isEmpty() || !((SdkInternalList)restoreDBInstanceFromS3Request.getProcessorFeatures()).isAutoConstruct()) {
            SdkInternalList processorFeaturesList = (SdkInternalList)restoreDBInstanceFromS3Request.getProcessorFeatures();
            int processorFeaturesListIndex = 1;
            for (ProcessorFeature processorFeaturesListValue : processorFeaturesList) {
                if (processorFeaturesListValue != null) {
                    if (processorFeaturesListValue.getName() != null) {
                        request.addParameter("ProcessorFeatures.ProcessorFeature." + processorFeaturesListIndex + ".Name", StringUtils.fromString((String)processorFeaturesListValue.getName()));
                    }
                    if (processorFeaturesListValue.getValue() != null) {
                        request.addParameter("ProcessorFeatures.ProcessorFeature." + processorFeaturesListIndex + ".Value", StringUtils.fromString((String)processorFeaturesListValue.getValue()));
                    }
                }
                ++processorFeaturesListIndex;
            }
        }
        if (restoreDBInstanceFromS3Request.getUseDefaultProcessorFeatures() != null) {
            request.addParameter("UseDefaultProcessorFeatures", StringUtils.fromBoolean((Boolean)restoreDBInstanceFromS3Request.getUseDefaultProcessorFeatures()));
        }
        if (restoreDBInstanceFromS3Request.getDeletionProtection() != null) {
            request.addParameter("DeletionProtection", StringUtils.fromBoolean((Boolean)restoreDBInstanceFromS3Request.getDeletionProtection()));
        }
        if (restoreDBInstanceFromS3Request.getMaxAllocatedStorage() != null) {
            request.addParameter("MaxAllocatedStorage", StringUtils.fromInteger((Integer)restoreDBInstanceFromS3Request.getMaxAllocatedStorage()));
        }
        if (restoreDBInstanceFromS3Request.getNetworkType() != null) {
            request.addParameter("NetworkType", StringUtils.fromString((String)restoreDBInstanceFromS3Request.getNetworkType()));
        }
        if (restoreDBInstanceFromS3Request.getStorageThroughput() != null) {
            request.addParameter("StorageThroughput", StringUtils.fromInteger((Integer)restoreDBInstanceFromS3Request.getStorageThroughput()));
        }
        if (restoreDBInstanceFromS3Request.getManageMasterUserPassword() != null) {
            request.addParameter("ManageMasterUserPassword", StringUtils.fromBoolean((Boolean)restoreDBInstanceFromS3Request.getManageMasterUserPassword()));
        }
        if (restoreDBInstanceFromS3Request.getMasterUserSecretKmsKeyId() != null) {
            request.addParameter("MasterUserSecretKmsKeyId", StringUtils.fromString((String)restoreDBInstanceFromS3Request.getMasterUserSecretKmsKeyId()));
        }
        return request;
    }
}

