/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.rds.model.DescribeIntegrationsRequest;
import com.amazonaws.services.rds.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeIntegrationsRequestMarshaller
implements Marshaller<Request<DescribeIntegrationsRequest>, DescribeIntegrationsRequest> {
    public Request<DescribeIntegrationsRequest> marshall(DescribeIntegrationsRequest describeIntegrationsRequest) {
        if (describeIntegrationsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeIntegrationsRequest, "AmazonRDS");
        request.addParameter("Action", "DescribeIntegrations");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeIntegrationsRequest.getIntegrationIdentifier() != null) {
            request.addParameter("IntegrationIdentifier", StringUtils.fromString((String)describeIntegrationsRequest.getIntegrationIdentifier()));
        }
        if (!describeIntegrationsRequest.getFilters().isEmpty() || !((SdkInternalList)describeIntegrationsRequest.getFilters()).isAutoConstruct()) {
            SdkInternalList filtersList = (SdkInternalList)describeIntegrationsRequest.getFilters();
            int filtersListIndex = 1;
            for (Filter filtersListValue : filtersList) {
                if (filtersListValue != null) {
                    if (filtersListValue.getName() != null) {
                        request.addParameter("Filters.Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)filtersListValue.getName()));
                    }
                    if (!filtersListValue.getValues().isEmpty() || !((SdkInternalList)filtersListValue.getValues()).isAutoConstruct()) {
                        SdkInternalList valuesList = (SdkInternalList)filtersListValue.getValues();
                        int valuesListIndex = 1;
                        for (String valuesListValue : valuesList) {
                            if (valuesListValue != null) {
                                request.addParameter("Filters.Filter." + filtersListIndex + ".Values.Value." + valuesListIndex, StringUtils.fromString((String)valuesListValue));
                            }
                            ++valuesListIndex;
                        }
                    }
                }
                ++filtersListIndex;
            }
        }
        if (describeIntegrationsRequest.getMaxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger((Integer)describeIntegrationsRequest.getMaxRecords()));
        }
        if (describeIntegrationsRequest.getMarker() != null) {
            request.addParameter("Marker", StringUtils.fromString((String)describeIntegrationsRequest.getMarker()));
        }
        return request;
    }
}

