/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.rds.model.DescribeTenantDatabasesRequest;
import com.amazonaws.services.rds.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeTenantDatabasesRequestMarshaller
implements Marshaller<Request<DescribeTenantDatabasesRequest>, DescribeTenantDatabasesRequest> {
    public Request<DescribeTenantDatabasesRequest> marshall(DescribeTenantDatabasesRequest describeTenantDatabasesRequest) {
        if (describeTenantDatabasesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeTenantDatabasesRequest, "AmazonRDS");
        request.addParameter("Action", "DescribeTenantDatabases");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeTenantDatabasesRequest.getDBInstanceIdentifier() != null) {
            request.addParameter("DBInstanceIdentifier", StringUtils.fromString((String)describeTenantDatabasesRequest.getDBInstanceIdentifier()));
        }
        if (describeTenantDatabasesRequest.getTenantDBName() != null) {
            request.addParameter("TenantDBName", StringUtils.fromString((String)describeTenantDatabasesRequest.getTenantDBName()));
        }
        if (!describeTenantDatabasesRequest.getFilters().isEmpty() || !((SdkInternalList)describeTenantDatabasesRequest.getFilters()).isAutoConstruct()) {
            SdkInternalList filtersList = (SdkInternalList)describeTenantDatabasesRequest.getFilters();
            int filtersListIndex = 1;
            for (Filter filtersListValue : filtersList) {
                if (filtersListValue != null) {
                    if (filtersListValue.getName() != null) {
                        request.addParameter("Filters.Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)filtersListValue.getName()));
                    }
                    if (!filtersListValue.getValues().isEmpty() || !((SdkInternalList)filtersListValue.getValues()).isAutoConstruct()) {
                        SdkInternalList valuesList = (SdkInternalList)filtersListValue.getValues();
                        int valuesListIndex = 1;
                        for (String valuesListValue : valuesList) {
                            if (valuesListValue != null) {
                                request.addParameter("Filters.Filter." + filtersListIndex + ".Values.Value." + valuesListIndex, StringUtils.fromString((String)valuesListValue));
                            }
                            ++valuesListIndex;
                        }
                    }
                }
                ++filtersListIndex;
            }
        }
        if (describeTenantDatabasesRequest.getMarker() != null) {
            request.addParameter("Marker", StringUtils.fromString((String)describeTenantDatabasesRequest.getMarker()));
        }
        if (describeTenantDatabasesRequest.getMaxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger((Integer)describeTenantDatabasesRequest.getMaxRecords()));
        }
        return request;
    }
}

