/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.rds.model.CreateDBShardGroupRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class CreateDBShardGroupRequestMarshaller
implements Marshaller<Request<CreateDBShardGroupRequest>, CreateDBShardGroupRequest> {
    public Request<CreateDBShardGroupRequest> marshall(CreateDBShardGroupRequest createDBShardGroupRequest) {
        if (createDBShardGroupRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createDBShardGroupRequest, "AmazonRDS");
        request.addParameter("Action", "CreateDBShardGroup");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (createDBShardGroupRequest.getDBShardGroupIdentifier() != null) {
            request.addParameter("DBShardGroupIdentifier", StringUtils.fromString((String)createDBShardGroupRequest.getDBShardGroupIdentifier()));
        }
        if (createDBShardGroupRequest.getDBClusterIdentifier() != null) {
            request.addParameter("DBClusterIdentifier", StringUtils.fromString((String)createDBShardGroupRequest.getDBClusterIdentifier()));
        }
        if (createDBShardGroupRequest.getComputeRedundancy() != null) {
            request.addParameter("ComputeRedundancy", StringUtils.fromInteger((Integer)createDBShardGroupRequest.getComputeRedundancy()));
        }
        if (createDBShardGroupRequest.getMaxACU() != null) {
            request.addParameter("MaxACU", StringUtils.fromDouble((Double)createDBShardGroupRequest.getMaxACU()));
        }
        if (createDBShardGroupRequest.getPubliclyAccessible() != null) {
            request.addParameter("PubliclyAccessible", StringUtils.fromBoolean((Boolean)createDBShardGroupRequest.getPubliclyAccessible()));
        }
        return request;
    }
}

