/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.rds.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CopyDBParameterGroupRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String sourceDBParameterGroupIdentifier;
    private String targetDBParameterGroupIdentifier;
    private String targetDBParameterGroupDescription;
    private ListWithAutoConstructFlag<Tag> tags;

    public String getSourceDBParameterGroupIdentifier() {
        return this.sourceDBParameterGroupIdentifier;
    }

    public void setSourceDBParameterGroupIdentifier(String sourceDBParameterGroupIdentifier) {
        this.sourceDBParameterGroupIdentifier = sourceDBParameterGroupIdentifier;
    }

    public CopyDBParameterGroupRequest withSourceDBParameterGroupIdentifier(String sourceDBParameterGroupIdentifier) {
        this.sourceDBParameterGroupIdentifier = sourceDBParameterGroupIdentifier;
        return this;
    }

    public String getTargetDBParameterGroupIdentifier() {
        return this.targetDBParameterGroupIdentifier;
    }

    public void setTargetDBParameterGroupIdentifier(String targetDBParameterGroupIdentifier) {
        this.targetDBParameterGroupIdentifier = targetDBParameterGroupIdentifier;
    }

    public CopyDBParameterGroupRequest withTargetDBParameterGroupIdentifier(String targetDBParameterGroupIdentifier) {
        this.targetDBParameterGroupIdentifier = targetDBParameterGroupIdentifier;
        return this;
    }

    public String getTargetDBParameterGroupDescription() {
        return this.targetDBParameterGroupDescription;
    }

    public void setTargetDBParameterGroupDescription(String targetDBParameterGroupDescription) {
        this.targetDBParameterGroupDescription = targetDBParameterGroupDescription;
    }

    public CopyDBParameterGroupRequest withTargetDBParameterGroupDescription(String targetDBParameterGroupDescription) {
        this.targetDBParameterGroupDescription = targetDBParameterGroupDescription;
        return this;
    }

    public List<Tag> getTags() {
        if (this.tags == null) {
            this.tags = new ListWithAutoConstructFlag();
            this.tags.setAutoConstruct(true);
        }
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        ListWithAutoConstructFlag tagsCopy = new ListWithAutoConstructFlag(tags.size());
        tagsCopy.addAll(tags);
        this.tags = tagsCopy;
    }

    public CopyDBParameterGroupRequest withTags(Tag ... tags) {
        if (this.getTags() == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag value : tags) {
            this.getTags().add(value);
        }
        return this;
    }

    public CopyDBParameterGroupRequest withTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
        } else {
            ListWithAutoConstructFlag tagsCopy = new ListWithAutoConstructFlag(tags.size());
            tagsCopy.addAll(tags);
            this.tags = tagsCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSourceDBParameterGroupIdentifier() != null) {
            sb.append("SourceDBParameterGroupIdentifier: " + this.getSourceDBParameterGroupIdentifier() + ",");
        }
        if (this.getTargetDBParameterGroupIdentifier() != null) {
            sb.append("TargetDBParameterGroupIdentifier: " + this.getTargetDBParameterGroupIdentifier() + ",");
        }
        if (this.getTargetDBParameterGroupDescription() != null) {
            sb.append("TargetDBParameterGroupDescription: " + this.getTargetDBParameterGroupDescription() + ",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: " + this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSourceDBParameterGroupIdentifier() == null ? 0 : this.getSourceDBParameterGroupIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getTargetDBParameterGroupIdentifier() == null ? 0 : this.getTargetDBParameterGroupIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getTargetDBParameterGroupDescription() == null ? 0 : this.getTargetDBParameterGroupDescription().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CopyDBParameterGroupRequest)) {
            return false;
        }
        CopyDBParameterGroupRequest other = (CopyDBParameterGroupRequest)obj;
        if (other.getSourceDBParameterGroupIdentifier() == null ^ this.getSourceDBParameterGroupIdentifier() == null) {
            return false;
        }
        if (other.getSourceDBParameterGroupIdentifier() != null && !other.getSourceDBParameterGroupIdentifier().equals(this.getSourceDBParameterGroupIdentifier())) {
            return false;
        }
        if (other.getTargetDBParameterGroupIdentifier() == null ^ this.getTargetDBParameterGroupIdentifier() == null) {
            return false;
        }
        if (other.getTargetDBParameterGroupIdentifier() != null && !other.getTargetDBParameterGroupIdentifier().equals(this.getTargetDBParameterGroupIdentifier())) {
            return false;
        }
        if (other.getTargetDBParameterGroupDescription() == null ^ this.getTargetDBParameterGroupDescription() == null) {
            return false;
        }
        if (other.getTargetDBParameterGroupDescription() != null && !other.getTargetDBParameterGroupDescription().equals(this.getTargetDBParameterGroupDescription())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public CopyDBParameterGroupRequest clone() {
        return (CopyDBParameterGroupRequest)super.clone();
    }
}

