/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.redshift.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.redshift.model.DescribeClusterSnapshotsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.Date;

public class DescribeClusterSnapshotsRequestMarshaller
implements Marshaller<Request<DescribeClusterSnapshotsRequest>, DescribeClusterSnapshotsRequest> {
    public Request<DescribeClusterSnapshotsRequest> marshall(DescribeClusterSnapshotsRequest describeClusterSnapshotsRequest) {
        SdkInternalList tagValuesList;
        SdkInternalList tagKeysList;
        if (describeClusterSnapshotsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeClusterSnapshotsRequest, "AmazonRedshift");
        request.addParameter("Action", "DescribeClusterSnapshots");
        request.addParameter("Version", "2012-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeClusterSnapshotsRequest.getClusterIdentifier() != null) {
            request.addParameter("ClusterIdentifier", StringUtils.fromString((String)describeClusterSnapshotsRequest.getClusterIdentifier()));
        }
        if (describeClusterSnapshotsRequest.getSnapshotIdentifier() != null) {
            request.addParameter("SnapshotIdentifier", StringUtils.fromString((String)describeClusterSnapshotsRequest.getSnapshotIdentifier()));
        }
        if (describeClusterSnapshotsRequest.getSnapshotType() != null) {
            request.addParameter("SnapshotType", StringUtils.fromString((String)describeClusterSnapshotsRequest.getSnapshotType()));
        }
        if (describeClusterSnapshotsRequest.getStartTime() != null) {
            request.addParameter("StartTime", StringUtils.fromDate((Date)describeClusterSnapshotsRequest.getStartTime()));
        }
        if (describeClusterSnapshotsRequest.getEndTime() != null) {
            request.addParameter("EndTime", StringUtils.fromDate((Date)describeClusterSnapshotsRequest.getEndTime()));
        }
        if (describeClusterSnapshotsRequest.getMaxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger((Integer)describeClusterSnapshotsRequest.getMaxRecords()));
        }
        if (describeClusterSnapshotsRequest.getMarker() != null) {
            request.addParameter("Marker", StringUtils.fromString((String)describeClusterSnapshotsRequest.getMarker()));
        }
        if (describeClusterSnapshotsRequest.getOwnerAccount() != null) {
            request.addParameter("OwnerAccount", StringUtils.fromString((String)describeClusterSnapshotsRequest.getOwnerAccount()));
        }
        if (!(tagKeysList = (SdkInternalList)describeClusterSnapshotsRequest.getTagKeys()).isEmpty() || !tagKeysList.isAutoConstruct()) {
            int tagKeysListIndex = 1;
            for (String tagKeysListValue : tagKeysList) {
                if (tagKeysListValue != null) {
                    request.addParameter("TagKeys.TagKey." + tagKeysListIndex, StringUtils.fromString((String)tagKeysListValue));
                }
                ++tagKeysListIndex;
            }
        }
        if (!(tagValuesList = (SdkInternalList)describeClusterSnapshotsRequest.getTagValues()).isEmpty() || !tagValuesList.isAutoConstruct()) {
            int tagValuesListIndex = 1;
            for (String tagValuesListValue : tagValuesList) {
                if (tagValuesListValue != null) {
                    request.addParameter("TagValues.TagValue." + tagValuesListIndex, StringUtils.fromString((String)tagValuesListValue));
                }
                ++tagValuesListIndex;
            }
        }
        return request;
    }
}

