/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.redshift.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.redshift.model.CreateScheduledActionRequest;
import com.amazonaws.services.redshift.model.PauseClusterMessage;
import com.amazonaws.services.redshift.model.ResizeClusterMessage;
import com.amazonaws.services.redshift.model.ResumeClusterMessage;
import com.amazonaws.services.redshift.model.ScheduledActionType;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.Date;

public class CreateScheduledActionRequestMarshaller
implements Marshaller<Request<CreateScheduledActionRequest>, CreateScheduledActionRequest> {
    public Request<CreateScheduledActionRequest> marshall(CreateScheduledActionRequest createScheduledActionRequest) {
        ScheduledActionType targetAction;
        if (createScheduledActionRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createScheduledActionRequest, "AmazonRedshift");
        request.addParameter("Action", "CreateScheduledAction");
        request.addParameter("Version", "2012-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (createScheduledActionRequest.getScheduledActionName() != null) {
            request.addParameter("ScheduledActionName", StringUtils.fromString((String)createScheduledActionRequest.getScheduledActionName()));
        }
        if ((targetAction = createScheduledActionRequest.getTargetAction()) != null) {
            ResumeClusterMessage resumeCluster;
            PauseClusterMessage pauseCluster;
            ResizeClusterMessage resizeCluster = targetAction.getResizeCluster();
            if (resizeCluster != null) {
                if (resizeCluster.getClusterIdentifier() != null) {
                    request.addParameter("TargetAction.ResizeCluster.ClusterIdentifier", StringUtils.fromString((String)resizeCluster.getClusterIdentifier()));
                }
                if (resizeCluster.getClusterType() != null) {
                    request.addParameter("TargetAction.ResizeCluster.ClusterType", StringUtils.fromString((String)resizeCluster.getClusterType()));
                }
                if (resizeCluster.getNodeType() != null) {
                    request.addParameter("TargetAction.ResizeCluster.NodeType", StringUtils.fromString((String)resizeCluster.getNodeType()));
                }
                if (resizeCluster.getNumberOfNodes() != null) {
                    request.addParameter("TargetAction.ResizeCluster.NumberOfNodes", StringUtils.fromInteger((Integer)resizeCluster.getNumberOfNodes()));
                }
                if (resizeCluster.getClassic() != null) {
                    request.addParameter("TargetAction.ResizeCluster.Classic", StringUtils.fromBoolean((Boolean)resizeCluster.getClassic()));
                }
                if (resizeCluster.getReservedNodeId() != null) {
                    request.addParameter("TargetAction.ResizeCluster.ReservedNodeId", StringUtils.fromString((String)resizeCluster.getReservedNodeId()));
                }
                if (resizeCluster.getTargetReservedNodeOfferingId() != null) {
                    request.addParameter("TargetAction.ResizeCluster.TargetReservedNodeOfferingId", StringUtils.fromString((String)resizeCluster.getTargetReservedNodeOfferingId()));
                }
            }
            if ((pauseCluster = targetAction.getPauseCluster()) != null && pauseCluster.getClusterIdentifier() != null) {
                request.addParameter("TargetAction.PauseCluster.ClusterIdentifier", StringUtils.fromString((String)pauseCluster.getClusterIdentifier()));
            }
            if ((resumeCluster = targetAction.getResumeCluster()) != null && resumeCluster.getClusterIdentifier() != null) {
                request.addParameter("TargetAction.ResumeCluster.ClusterIdentifier", StringUtils.fromString((String)resumeCluster.getClusterIdentifier()));
            }
        }
        if (createScheduledActionRequest.getSchedule() != null) {
            request.addParameter("Schedule", StringUtils.fromString((String)createScheduledActionRequest.getSchedule()));
        }
        if (createScheduledActionRequest.getIamRole() != null) {
            request.addParameter("IamRole", StringUtils.fromString((String)createScheduledActionRequest.getIamRole()));
        }
        if (createScheduledActionRequest.getScheduledActionDescription() != null) {
            request.addParameter("ScheduledActionDescription", StringUtils.fromString((String)createScheduledActionRequest.getScheduledActionDescription()));
        }
        if (createScheduledActionRequest.getStartTime() != null) {
            request.addParameter("StartTime", StringUtils.fromDate((Date)createScheduledActionRequest.getStartTime()));
        }
        if (createScheduledActionRequest.getEndTime() != null) {
            request.addParameter("EndTime", StringUtils.fromDate((Date)createScheduledActionRequest.getEndTime()));
        }
        if (createScheduledActionRequest.getEnable() != null) {
            request.addParameter("Enable", StringUtils.fromBoolean((Boolean)createScheduledActionRequest.getEnable()));
        }
        return request;
    }
}

