/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.redshift.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.redshift.model.AuthorizeEndpointAccessRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class AuthorizeEndpointAccessRequestMarshaller
implements Marshaller<Request<AuthorizeEndpointAccessRequest>, AuthorizeEndpointAccessRequest> {
    public Request<AuthorizeEndpointAccessRequest> marshall(AuthorizeEndpointAccessRequest authorizeEndpointAccessRequest) {
        if (authorizeEndpointAccessRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)authorizeEndpointAccessRequest, "AmazonRedshift");
        request.addParameter("Action", "AuthorizeEndpointAccess");
        request.addParameter("Version", "2012-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (authorizeEndpointAccessRequest.getClusterIdentifier() != null) {
            request.addParameter("ClusterIdentifier", StringUtils.fromString((String)authorizeEndpointAccessRequest.getClusterIdentifier()));
        }
        if (authorizeEndpointAccessRequest.getAccount() != null) {
            request.addParameter("Account", StringUtils.fromString((String)authorizeEndpointAccessRequest.getAccount()));
        }
        if (!authorizeEndpointAccessRequest.getVpcIds().isEmpty() || !((SdkInternalList)authorizeEndpointAccessRequest.getVpcIds()).isAutoConstruct()) {
            SdkInternalList vpcIdsList = (SdkInternalList)authorizeEndpointAccessRequest.getVpcIds();
            int vpcIdsListIndex = 1;
            for (String vpcIdsListValue : vpcIdsList) {
                if (vpcIdsListValue != null) {
                    request.addParameter("VpcIds.VpcIdentifier." + vpcIdsListIndex, StringUtils.fromString((String)vpcIdsListValue));
                }
                ++vpcIdsListIndex;
            }
        }
        return request;
    }
}

