/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.redshift.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.redshift.model.ImpactRankingType;
import com.amazonaws.services.redshift.model.RecommendedAction;
import com.amazonaws.services.redshift.model.ReferenceLink;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class Recommendation
implements Serializable,
Cloneable {
    private String id;
    private String clusterIdentifier;
    private String namespaceArn;
    private Date createdAt;
    private String recommendationType;
    private String title;
    private String description;
    private String observation;
    private String impactRanking;
    private String recommendationText;
    private SdkInternalList<RecommendedAction> recommendedActions;
    private SdkInternalList<ReferenceLink> referenceLinks;

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public Recommendation withId(String id) {
        this.setId(id);
        return this;
    }

    public void setClusterIdentifier(String clusterIdentifier) {
        this.clusterIdentifier = clusterIdentifier;
    }

    public String getClusterIdentifier() {
        return this.clusterIdentifier;
    }

    public Recommendation withClusterIdentifier(String clusterIdentifier) {
        this.setClusterIdentifier(clusterIdentifier);
        return this;
    }

    public void setNamespaceArn(String namespaceArn) {
        this.namespaceArn = namespaceArn;
    }

    public String getNamespaceArn() {
        return this.namespaceArn;
    }

    public Recommendation withNamespaceArn(String namespaceArn) {
        this.setNamespaceArn(namespaceArn);
        return this;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public Recommendation withCreatedAt(Date createdAt) {
        this.setCreatedAt(createdAt);
        return this;
    }

    public void setRecommendationType(String recommendationType) {
        this.recommendationType = recommendationType;
    }

    public String getRecommendationType() {
        return this.recommendationType;
    }

    public Recommendation withRecommendationType(String recommendationType) {
        this.setRecommendationType(recommendationType);
        return this;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public Recommendation withTitle(String title) {
        this.setTitle(title);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public Recommendation withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setObservation(String observation) {
        this.observation = observation;
    }

    public String getObservation() {
        return this.observation;
    }

    public Recommendation withObservation(String observation) {
        this.setObservation(observation);
        return this;
    }

    public void setImpactRanking(String impactRanking) {
        this.impactRanking = impactRanking;
    }

    public String getImpactRanking() {
        return this.impactRanking;
    }

    public Recommendation withImpactRanking(String impactRanking) {
        this.setImpactRanking(impactRanking);
        return this;
    }

    public Recommendation withImpactRanking(ImpactRankingType impactRanking) {
        this.impactRanking = impactRanking.toString();
        return this;
    }

    public void setRecommendationText(String recommendationText) {
        this.recommendationText = recommendationText;
    }

    public String getRecommendationText() {
        return this.recommendationText;
    }

    public Recommendation withRecommendationText(String recommendationText) {
        this.setRecommendationText(recommendationText);
        return this;
    }

    public List<RecommendedAction> getRecommendedActions() {
        if (this.recommendedActions == null) {
            this.recommendedActions = new SdkInternalList();
        }
        return this.recommendedActions;
    }

    public void setRecommendedActions(Collection<RecommendedAction> recommendedActions) {
        if (recommendedActions == null) {
            this.recommendedActions = null;
            return;
        }
        this.recommendedActions = new SdkInternalList(recommendedActions);
    }

    public Recommendation withRecommendedActions(RecommendedAction ... recommendedActions) {
        if (this.recommendedActions == null) {
            this.setRecommendedActions((Collection<RecommendedAction>)new SdkInternalList(recommendedActions.length));
        }
        for (RecommendedAction ele : recommendedActions) {
            this.recommendedActions.add((Object)ele);
        }
        return this;
    }

    public Recommendation withRecommendedActions(Collection<RecommendedAction> recommendedActions) {
        this.setRecommendedActions(recommendedActions);
        return this;
    }

    public List<ReferenceLink> getReferenceLinks() {
        if (this.referenceLinks == null) {
            this.referenceLinks = new SdkInternalList();
        }
        return this.referenceLinks;
    }

    public void setReferenceLinks(Collection<ReferenceLink> referenceLinks) {
        if (referenceLinks == null) {
            this.referenceLinks = null;
            return;
        }
        this.referenceLinks = new SdkInternalList(referenceLinks);
    }

    public Recommendation withReferenceLinks(ReferenceLink ... referenceLinks) {
        if (this.referenceLinks == null) {
            this.setReferenceLinks((Collection<ReferenceLink>)new SdkInternalList(referenceLinks.length));
        }
        for (ReferenceLink ele : referenceLinks) {
            this.referenceLinks.add((Object)ele);
        }
        return this;
    }

    public Recommendation withReferenceLinks(Collection<ReferenceLink> referenceLinks) {
        this.setReferenceLinks(referenceLinks);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getId() != null) {
            sb.append("Id: ").append(this.getId()).append(",");
        }
        if (this.getClusterIdentifier() != null) {
            sb.append("ClusterIdentifier: ").append(this.getClusterIdentifier()).append(",");
        }
        if (this.getNamespaceArn() != null) {
            sb.append("NamespaceArn: ").append(this.getNamespaceArn()).append(",");
        }
        if (this.getCreatedAt() != null) {
            sb.append("CreatedAt: ").append(this.getCreatedAt()).append(",");
        }
        if (this.getRecommendationType() != null) {
            sb.append("RecommendationType: ").append(this.getRecommendationType()).append(",");
        }
        if (this.getTitle() != null) {
            sb.append("Title: ").append(this.getTitle()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getObservation() != null) {
            sb.append("Observation: ").append(this.getObservation()).append(",");
        }
        if (this.getImpactRanking() != null) {
            sb.append("ImpactRanking: ").append(this.getImpactRanking()).append(",");
        }
        if (this.getRecommendationText() != null) {
            sb.append("RecommendationText: ").append(this.getRecommendationText()).append(",");
        }
        if (this.getRecommendedActions() != null) {
            sb.append("RecommendedActions: ").append(this.getRecommendedActions()).append(",");
        }
        if (this.getReferenceLinks() != null) {
            sb.append("ReferenceLinks: ").append(this.getReferenceLinks());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Recommendation)) {
            return false;
        }
        Recommendation other = (Recommendation)obj;
        if (other.getId() == null ^ this.getId() == null) {
            return false;
        }
        if (other.getId() != null && !other.getId().equals(this.getId())) {
            return false;
        }
        if (other.getClusterIdentifier() == null ^ this.getClusterIdentifier() == null) {
            return false;
        }
        if (other.getClusterIdentifier() != null && !other.getClusterIdentifier().equals(this.getClusterIdentifier())) {
            return false;
        }
        if (other.getNamespaceArn() == null ^ this.getNamespaceArn() == null) {
            return false;
        }
        if (other.getNamespaceArn() != null && !other.getNamespaceArn().equals(this.getNamespaceArn())) {
            return false;
        }
        if (other.getCreatedAt() == null ^ this.getCreatedAt() == null) {
            return false;
        }
        if (other.getCreatedAt() != null && !other.getCreatedAt().equals(this.getCreatedAt())) {
            return false;
        }
        if (other.getRecommendationType() == null ^ this.getRecommendationType() == null) {
            return false;
        }
        if (other.getRecommendationType() != null && !other.getRecommendationType().equals(this.getRecommendationType())) {
            return false;
        }
        if (other.getTitle() == null ^ this.getTitle() == null) {
            return false;
        }
        if (other.getTitle() != null && !other.getTitle().equals(this.getTitle())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getObservation() == null ^ this.getObservation() == null) {
            return false;
        }
        if (other.getObservation() != null && !other.getObservation().equals(this.getObservation())) {
            return false;
        }
        if (other.getImpactRanking() == null ^ this.getImpactRanking() == null) {
            return false;
        }
        if (other.getImpactRanking() != null && !other.getImpactRanking().equals(this.getImpactRanking())) {
            return false;
        }
        if (other.getRecommendationText() == null ^ this.getRecommendationText() == null) {
            return false;
        }
        if (other.getRecommendationText() != null && !other.getRecommendationText().equals(this.getRecommendationText())) {
            return false;
        }
        if (other.getRecommendedActions() == null ^ this.getRecommendedActions() == null) {
            return false;
        }
        if (other.getRecommendedActions() != null && !other.getRecommendedActions().equals(this.getRecommendedActions())) {
            return false;
        }
        if (other.getReferenceLinks() == null ^ this.getReferenceLinks() == null) {
            return false;
        }
        return other.getReferenceLinks() == null || other.getReferenceLinks().equals(this.getReferenceLinks());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getId() == null ? 0 : this.getId().hashCode());
        hashCode = 31 * hashCode + (this.getClusterIdentifier() == null ? 0 : this.getClusterIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getNamespaceArn() == null ? 0 : this.getNamespaceArn().hashCode());
        hashCode = 31 * hashCode + (this.getCreatedAt() == null ? 0 : this.getCreatedAt().hashCode());
        hashCode = 31 * hashCode + (this.getRecommendationType() == null ? 0 : this.getRecommendationType().hashCode());
        hashCode = 31 * hashCode + (this.getTitle() == null ? 0 : this.getTitle().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getObservation() == null ? 0 : this.getObservation().hashCode());
        hashCode = 31 * hashCode + (this.getImpactRanking() == null ? 0 : this.getImpactRanking().hashCode());
        hashCode = 31 * hashCode + (this.getRecommendationText() == null ? 0 : this.getRecommendationText().hashCode());
        hashCode = 31 * hashCode + (this.getRecommendedActions() == null ? 0 : this.getRecommendedActions().hashCode());
        hashCode = 31 * hashCode + (this.getReferenceLinks() == null ? 0 : this.getReferenceLinks().hashCode());
        return hashCode;
    }

    public Recommendation clone() {
        try {
            return (Recommendation)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

