/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3control.model;

import com.amazonaws.services.s3control.model.ObjectLambdaContentTransformation;
import com.amazonaws.services.s3control.model.ObjectLambdaTransformationConfigurationAction;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ObjectLambdaTransformationConfiguration
implements Serializable,
Cloneable {
    private List<String> actions;
    private ObjectLambdaContentTransformation contentTransformation;

    public List<String> getActions() {
        return this.actions;
    }

    public void setActions(Collection<String> actions) {
        if (actions == null) {
            this.actions = null;
            return;
        }
        this.actions = new ArrayList<String>(actions);
    }

    public ObjectLambdaTransformationConfiguration withActions(String ... actions) {
        if (this.actions == null) {
            this.setActions(new ArrayList<String>(actions.length));
        }
        for (String ele : actions) {
            this.actions.add(ele);
        }
        return this;
    }

    public ObjectLambdaTransformationConfiguration withActions(Collection<String> actions) {
        this.setActions(actions);
        return this;
    }

    public ObjectLambdaTransformationConfiguration withActions(ObjectLambdaTransformationConfigurationAction ... actions) {
        ArrayList<String> actionsCopy = new ArrayList<String>(actions.length);
        for (ObjectLambdaTransformationConfigurationAction value : actions) {
            actionsCopy.add(value.toString());
        }
        if (this.getActions() == null) {
            this.setActions(actionsCopy);
        } else {
            this.getActions().addAll(actionsCopy);
        }
        return this;
    }

    public void setContentTransformation(ObjectLambdaContentTransformation contentTransformation) {
        this.contentTransformation = contentTransformation;
    }

    public ObjectLambdaContentTransformation getContentTransformation() {
        return this.contentTransformation;
    }

    public ObjectLambdaTransformationConfiguration withContentTransformation(ObjectLambdaContentTransformation contentTransformation) {
        this.setContentTransformation(contentTransformation);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getActions() != null) {
            sb.append("Actions: ").append(this.getActions()).append(",");
        }
        if (this.getContentTransformation() != null) {
            sb.append("ContentTransformation: ").append(this.getContentTransformation());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ObjectLambdaTransformationConfiguration)) {
            return false;
        }
        ObjectLambdaTransformationConfiguration other = (ObjectLambdaTransformationConfiguration)obj;
        if (other.getActions() == null ^ this.getActions() == null) {
            return false;
        }
        if (other.getActions() != null && !other.getActions().equals(this.getActions())) {
            return false;
        }
        if (other.getContentTransformation() == null ^ this.getContentTransformation() == null) {
            return false;
        }
        return other.getContentTransformation() == null || other.getContentTransformation().equals(this.getContentTransformation());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getActions() == null ? 0 : this.getActions().hashCode());
        hashCode = 31 * hashCode + (this.getContentTransformation() == null ? 0 : this.getContentTransformation().hashCode());
        return hashCode;
    }

    public ObjectLambdaTransformationConfiguration clone() {
        try {
            return (ObjectLambdaTransformationConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

