/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3control.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.services.s3control.S3ControlResponseMetadata;
import com.amazonaws.services.s3control.model.ListAccessGrantEntry;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListAccessGrantsResult
extends AmazonWebServiceResult<S3ControlResponseMetadata>
implements Serializable,
Cloneable {
    private String nextToken;
    private List<ListAccessGrantEntry> accessGrantsList;

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListAccessGrantsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public List<ListAccessGrantEntry> getAccessGrantsList() {
        return this.accessGrantsList;
    }

    public void setAccessGrantsList(Collection<ListAccessGrantEntry> accessGrantsList) {
        if (accessGrantsList == null) {
            this.accessGrantsList = null;
            return;
        }
        this.accessGrantsList = new ArrayList<ListAccessGrantEntry>(accessGrantsList);
    }

    public ListAccessGrantsResult withAccessGrantsList(ListAccessGrantEntry ... accessGrantsList) {
        if (this.accessGrantsList == null) {
            this.setAccessGrantsList(new ArrayList<ListAccessGrantEntry>(accessGrantsList.length));
        }
        for (ListAccessGrantEntry ele : accessGrantsList) {
            this.accessGrantsList.add(ele);
        }
        return this;
    }

    public ListAccessGrantsResult withAccessGrantsList(Collection<ListAccessGrantEntry> accessGrantsList) {
        this.setAccessGrantsList(accessGrantsList);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getAccessGrantsList() != null) {
            sb.append("AccessGrantsList: ").append(this.getAccessGrantsList());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAccessGrantsResult)) {
            return false;
        }
        ListAccessGrantsResult other = (ListAccessGrantsResult)obj;
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getAccessGrantsList() == null ^ this.getAccessGrantsList() == null) {
            return false;
        }
        return other.getAccessGrantsList() == null || other.getAccessGrantsList().equals(this.getAccessGrantsList());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getAccessGrantsList() == null ? 0 : this.getAccessGrantsList().hashCode());
        return hashCode;
    }

    public ListAccessGrantsResult clone() {
        try {
            return (ListAccessGrantsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

