/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3control.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.s3control.model.CreateAccessGrantsLocationRequest;
import com.amazonaws.services.s3control.model.Tag;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.XMLWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;

public class CreateAccessGrantsLocationRequestMarshaller
implements Marshaller<Request<CreateAccessGrantsLocationRequest>, CreateAccessGrantsLocationRequest> {
    public Request<CreateAccessGrantsLocationRequest> marshall(CreateAccessGrantsLocationRequest createAccessGrantsLocationRequest) {
        if (createAccessGrantsLocationRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createAccessGrantsLocationRequest, "AWSS3Control");
        request.setHttpMethod(HttpMethodName.POST);
        if (createAccessGrantsLocationRequest.getAccountId() != null) {
            request.addHeader("x-amz-account-id", StringUtils.fromString((String)createAccessGrantsLocationRequest.getAccountId()));
        }
        String uriResourcePath = "/v20180820/accessgrantsinstance/location";
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            XMLWriter xmlWriter = new XMLWriter((Writer)stringWriter, "http://awss3control.amazonaws.com/doc/2018-08-20/");
            xmlWriter.startElement("CreateAccessGrantsLocationRequest");
            if (createAccessGrantsLocationRequest != null) {
                List<Tag> createAccessGrantsLocationRequestTagsList;
                if (createAccessGrantsLocationRequest.getLocationScope() != null) {
                    xmlWriter.startElement("LocationScope").value(createAccessGrantsLocationRequest.getLocationScope()).endElement();
                }
                if (createAccessGrantsLocationRequest.getIAMRoleArn() != null) {
                    xmlWriter.startElement("IAMRoleArn").value(createAccessGrantsLocationRequest.getIAMRoleArn()).endElement();
                }
                if ((createAccessGrantsLocationRequestTagsList = createAccessGrantsLocationRequest.getTags()) != null) {
                    xmlWriter.startElement("Tags");
                    for (Tag createAccessGrantsLocationRequestTagsListValue : createAccessGrantsLocationRequestTagsList) {
                        xmlWriter.startElement("Tag");
                        if (createAccessGrantsLocationRequestTagsListValue.getKey() != null) {
                            xmlWriter.startElement("Key").value(createAccessGrantsLocationRequestTagsListValue.getKey()).endElement();
                        }
                        if (createAccessGrantsLocationRequestTagsListValue.getValue() != null) {
                            xmlWriter.startElement("Value").value(createAccessGrantsLocationRequestTagsListValue.getValue()).endElement();
                        }
                        xmlWriter.endElement();
                    }
                    xmlWriter.endElement();
                }
            }
            xmlWriter.endElement();
            request.setContent((InputStream)new StringInputStream(stringWriter.getBuffer().toString()));
            request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(StringUtils.UTF8).length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to XML: " + t.getMessage(), t);
        }
        return request;
    }
}

