/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3control.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.s3control.model.Tag;
import com.amazonaws.services.s3control.model.TagResourceRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.transform.PathMarshallers;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.XMLWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;

public class TagResourceRequestMarshaller
implements Marshaller<Request<TagResourceRequest>, TagResourceRequest> {
    public Request<TagResourceRequest> marshall(TagResourceRequest tagResourceRequest) {
        if (tagResourceRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)tagResourceRequest, "AWSS3Control");
        request.setHttpMethod(HttpMethodName.POST);
        if (tagResourceRequest.getAccountId() != null) {
            request.addHeader("x-amz-account-id", StringUtils.fromString((String)tagResourceRequest.getAccountId()));
        }
        String uriResourcePath = "/v20180820/tags/{resourceArn+}";
        uriResourcePath = PathMarshallers.GREEDY.marshall(uriResourcePath, "resourceArn", tagResourceRequest.getResourceArn());
        request.setResourcePath(uriResourcePath);
        try {
            List<Tag> tagResourceRequestTagsList;
            StringWriter stringWriter = new StringWriter();
            XMLWriter xmlWriter = new XMLWriter((Writer)stringWriter, "http://awss3control.amazonaws.com/doc/2018-08-20/");
            xmlWriter.startElement("TagResourceRequest");
            if (tagResourceRequest != null && (tagResourceRequestTagsList = tagResourceRequest.getTags()) != null) {
                xmlWriter.startElement("Tags");
                for (Tag tagResourceRequestTagsListValue : tagResourceRequestTagsList) {
                    xmlWriter.startElement("Tag");
                    if (tagResourceRequestTagsListValue.getKey() != null) {
                        xmlWriter.startElement("Key").value(tagResourceRequestTagsListValue.getKey()).endElement();
                    }
                    if (tagResourceRequestTagsListValue.getValue() != null) {
                        xmlWriter.startElement("Value").value(tagResourceRequestTagsListValue.getValue()).endElement();
                    }
                    xmlWriter.endElement();
                }
                xmlWriter.endElement();
            }
            xmlWriter.endElement();
            request.setContent((InputStream)new StringInputStream(stringWriter.getBuffer().toString()));
            request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(StringUtils.UTF8).length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to XML: " + t.getMessage(), t);
        }
        return request;
    }
}

