/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.signer.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.signer.model.Permission;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListProfilePermissionsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String revisionId;
    private Integer policySizeBytes;
    private List<Permission> permissions;
    private String nextToken;

    public void setRevisionId(String revisionId) {
        this.revisionId = revisionId;
    }

    public String getRevisionId() {
        return this.revisionId;
    }

    public ListProfilePermissionsResult withRevisionId(String revisionId) {
        this.setRevisionId(revisionId);
        return this;
    }

    public void setPolicySizeBytes(Integer policySizeBytes) {
        this.policySizeBytes = policySizeBytes;
    }

    public Integer getPolicySizeBytes() {
        return this.policySizeBytes;
    }

    public ListProfilePermissionsResult withPolicySizeBytes(Integer policySizeBytes) {
        this.setPolicySizeBytes(policySizeBytes);
        return this;
    }

    public List<Permission> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(Collection<Permission> permissions) {
        if (permissions == null) {
            this.permissions = null;
            return;
        }
        this.permissions = new ArrayList<Permission>(permissions);
    }

    public ListProfilePermissionsResult withPermissions(Permission ... permissions) {
        if (this.permissions == null) {
            this.setPermissions(new ArrayList<Permission>(permissions.length));
        }
        for (Permission ele : permissions) {
            this.permissions.add(ele);
        }
        return this;
    }

    public ListProfilePermissionsResult withPermissions(Collection<Permission> permissions) {
        this.setPermissions(permissions);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListProfilePermissionsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getRevisionId() != null) {
            sb.append("RevisionId: ").append(this.getRevisionId()).append(",");
        }
        if (this.getPolicySizeBytes() != null) {
            sb.append("PolicySizeBytes: ").append(this.getPolicySizeBytes()).append(",");
        }
        if (this.getPermissions() != null) {
            sb.append("Permissions: ").append(this.getPermissions()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListProfilePermissionsResult)) {
            return false;
        }
        ListProfilePermissionsResult other = (ListProfilePermissionsResult)obj;
        if (other.getRevisionId() == null ^ this.getRevisionId() == null) {
            return false;
        }
        if (other.getRevisionId() != null && !other.getRevisionId().equals(this.getRevisionId())) {
            return false;
        }
        if (other.getPolicySizeBytes() == null ^ this.getPolicySizeBytes() == null) {
            return false;
        }
        if (other.getPolicySizeBytes() != null && !other.getPolicySizeBytes().equals(this.getPolicySizeBytes())) {
            return false;
        }
        if (other.getPermissions() == null ^ this.getPermissions() == null) {
            return false;
        }
        if (other.getPermissions() != null && !other.getPermissions().equals(this.getPermissions())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getRevisionId() == null ? 0 : this.getRevisionId().hashCode());
        hashCode = 31 * hashCode + (this.getPolicySizeBytes() == null ? 0 : this.getPolicySizeBytes().hashCode());
        hashCode = 31 * hashCode + (this.getPermissions() == null ? 0 : this.getPermissions().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListProfilePermissionsResult clone() {
        try {
            return (ListProfilePermissionsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

