/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.signer;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.signer.AWSsignerAsync;
import com.amazonaws.services.signer.AWSsignerAsyncClientBuilder;
import com.amazonaws.services.signer.AWSsignerClient;
import com.amazonaws.services.signer.model.AddProfilePermissionRequest;
import com.amazonaws.services.signer.model.AddProfilePermissionResult;
import com.amazonaws.services.signer.model.CancelSigningProfileRequest;
import com.amazonaws.services.signer.model.CancelSigningProfileResult;
import com.amazonaws.services.signer.model.DescribeSigningJobRequest;
import com.amazonaws.services.signer.model.DescribeSigningJobResult;
import com.amazonaws.services.signer.model.GetSigningPlatformRequest;
import com.amazonaws.services.signer.model.GetSigningPlatformResult;
import com.amazonaws.services.signer.model.GetSigningProfileRequest;
import com.amazonaws.services.signer.model.GetSigningProfileResult;
import com.amazonaws.services.signer.model.ListProfilePermissionsRequest;
import com.amazonaws.services.signer.model.ListProfilePermissionsResult;
import com.amazonaws.services.signer.model.ListSigningJobsRequest;
import com.amazonaws.services.signer.model.ListSigningJobsResult;
import com.amazonaws.services.signer.model.ListSigningPlatformsRequest;
import com.amazonaws.services.signer.model.ListSigningPlatformsResult;
import com.amazonaws.services.signer.model.ListSigningProfilesRequest;
import com.amazonaws.services.signer.model.ListSigningProfilesResult;
import com.amazonaws.services.signer.model.ListTagsForResourceRequest;
import com.amazonaws.services.signer.model.ListTagsForResourceResult;
import com.amazonaws.services.signer.model.PutSigningProfileRequest;
import com.amazonaws.services.signer.model.PutSigningProfileResult;
import com.amazonaws.services.signer.model.RemoveProfilePermissionRequest;
import com.amazonaws.services.signer.model.RemoveProfilePermissionResult;
import com.amazonaws.services.signer.model.RevokeSignatureRequest;
import com.amazonaws.services.signer.model.RevokeSignatureResult;
import com.amazonaws.services.signer.model.RevokeSigningProfileRequest;
import com.amazonaws.services.signer.model.RevokeSigningProfileResult;
import com.amazonaws.services.signer.model.StartSigningJobRequest;
import com.amazonaws.services.signer.model.StartSigningJobResult;
import com.amazonaws.services.signer.model.TagResourceRequest;
import com.amazonaws.services.signer.model.TagResourceResult;
import com.amazonaws.services.signer.model.UntagResourceRequest;
import com.amazonaws.services.signer.model.UntagResourceResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSsignerAsyncClient
extends AWSsignerClient
implements AWSsignerAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSsignerAsyncClientBuilder asyncBuilder() {
        return AWSsignerAsyncClientBuilder.standard();
    }

    AWSsignerAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AWSsignerAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<AddProfilePermissionResult> addProfilePermissionAsync(AddProfilePermissionRequest request) {
        return this.addProfilePermissionAsync(request, null);
    }

    @Override
    public Future<AddProfilePermissionResult> addProfilePermissionAsync(AddProfilePermissionRequest request, final AsyncHandler<AddProfilePermissionRequest, AddProfilePermissionResult> asyncHandler) {
        final AddProfilePermissionRequest finalRequest = (AddProfilePermissionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<AddProfilePermissionResult>(){

            @Override
            public AddProfilePermissionResult call() throws Exception {
                AddProfilePermissionResult result = null;
                try {
                    result = AWSsignerAsyncClient.this.executeAddProfilePermission(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CancelSigningProfileResult> cancelSigningProfileAsync(CancelSigningProfileRequest request) {
        return this.cancelSigningProfileAsync(request, null);
    }

    @Override
    public Future<CancelSigningProfileResult> cancelSigningProfileAsync(CancelSigningProfileRequest request, final AsyncHandler<CancelSigningProfileRequest, CancelSigningProfileResult> asyncHandler) {
        final CancelSigningProfileRequest finalRequest = (CancelSigningProfileRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CancelSigningProfileResult>(){

            @Override
            public CancelSigningProfileResult call() throws Exception {
                CancelSigningProfileResult result = null;
                try {
                    result = AWSsignerAsyncClient.this.executeCancelSigningProfile(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeSigningJobResult> describeSigningJobAsync(DescribeSigningJobRequest request) {
        return this.describeSigningJobAsync(request, null);
    }

    @Override
    public Future<DescribeSigningJobResult> describeSigningJobAsync(DescribeSigningJobRequest request, final AsyncHandler<DescribeSigningJobRequest, DescribeSigningJobResult> asyncHandler) {
        final DescribeSigningJobRequest finalRequest = (DescribeSigningJobRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeSigningJobResult>(){

            @Override
            public DescribeSigningJobResult call() throws Exception {
                DescribeSigningJobResult result = null;
                try {
                    result = AWSsignerAsyncClient.this.executeDescribeSigningJob(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetSigningPlatformResult> getSigningPlatformAsync(GetSigningPlatformRequest request) {
        return this.getSigningPlatformAsync(request, null);
    }

    @Override
    public Future<GetSigningPlatformResult> getSigningPlatformAsync(GetSigningPlatformRequest request, final AsyncHandler<GetSigningPlatformRequest, GetSigningPlatformResult> asyncHandler) {
        final GetSigningPlatformRequest finalRequest = (GetSigningPlatformRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetSigningPlatformResult>(){

            @Override
            public GetSigningPlatformResult call() throws Exception {
                GetSigningPlatformResult result = null;
                try {
                    result = AWSsignerAsyncClient.this.executeGetSigningPlatform(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetSigningProfileResult> getSigningProfileAsync(GetSigningProfileRequest request) {
        return this.getSigningProfileAsync(request, null);
    }

    @Override
    public Future<GetSigningProfileResult> getSigningProfileAsync(GetSigningProfileRequest request, final AsyncHandler<GetSigningProfileRequest, GetSigningProfileResult> asyncHandler) {
        final GetSigningProfileRequest finalRequest = (GetSigningProfileRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetSigningProfileResult>(){

            @Override
            public GetSigningProfileResult call() throws Exception {
                GetSigningProfileResult result = null;
                try {
                    result = AWSsignerAsyncClient.this.executeGetSigningProfile(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListProfilePermissionsResult> listProfilePermissionsAsync(ListProfilePermissionsRequest request) {
        return this.listProfilePermissionsAsync(request, null);
    }

    @Override
    public Future<ListProfilePermissionsResult> listProfilePermissionsAsync(ListProfilePermissionsRequest request, final AsyncHandler<ListProfilePermissionsRequest, ListProfilePermissionsResult> asyncHandler) {
        final ListProfilePermissionsRequest finalRequest = (ListProfilePermissionsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListProfilePermissionsResult>(){

            @Override
            public ListProfilePermissionsResult call() throws Exception {
                ListProfilePermissionsResult result = null;
                try {
                    result = AWSsignerAsyncClient.this.executeListProfilePermissions(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListSigningJobsResult> listSigningJobsAsync(ListSigningJobsRequest request) {
        return this.listSigningJobsAsync(request, null);
    }

    @Override
    public Future<ListSigningJobsResult> listSigningJobsAsync(ListSigningJobsRequest request, final AsyncHandler<ListSigningJobsRequest, ListSigningJobsResult> asyncHandler) {
        final ListSigningJobsRequest finalRequest = (ListSigningJobsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListSigningJobsResult>(){

            @Override
            public ListSigningJobsResult call() throws Exception {
                ListSigningJobsResult result = null;
                try {
                    result = AWSsignerAsyncClient.this.executeListSigningJobs(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListSigningPlatformsResult> listSigningPlatformsAsync(ListSigningPlatformsRequest request) {
        return this.listSigningPlatformsAsync(request, null);
    }

    @Override
    public Future<ListSigningPlatformsResult> listSigningPlatformsAsync(ListSigningPlatformsRequest request, final AsyncHandler<ListSigningPlatformsRequest, ListSigningPlatformsResult> asyncHandler) {
        final ListSigningPlatformsRequest finalRequest = (ListSigningPlatformsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListSigningPlatformsResult>(){

            @Override
            public ListSigningPlatformsResult call() throws Exception {
                ListSigningPlatformsResult result = null;
                try {
                    result = AWSsignerAsyncClient.this.executeListSigningPlatforms(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListSigningProfilesResult> listSigningProfilesAsync(ListSigningProfilesRequest request) {
        return this.listSigningProfilesAsync(request, null);
    }

    @Override
    public Future<ListSigningProfilesResult> listSigningProfilesAsync(ListSigningProfilesRequest request, final AsyncHandler<ListSigningProfilesRequest, ListSigningProfilesResult> asyncHandler) {
        final ListSigningProfilesRequest finalRequest = (ListSigningProfilesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListSigningProfilesResult>(){

            @Override
            public ListSigningProfilesResult call() throws Exception {
                ListSigningProfilesResult result = null;
                try {
                    result = AWSsignerAsyncClient.this.executeListSigningProfiles(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        final ListTagsForResourceRequest finalRequest = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result = null;
                try {
                    result = AWSsignerAsyncClient.this.executeListTagsForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutSigningProfileResult> putSigningProfileAsync(PutSigningProfileRequest request) {
        return this.putSigningProfileAsync(request, null);
    }

    @Override
    public Future<PutSigningProfileResult> putSigningProfileAsync(PutSigningProfileRequest request, final AsyncHandler<PutSigningProfileRequest, PutSigningProfileResult> asyncHandler) {
        final PutSigningProfileRequest finalRequest = (PutSigningProfileRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutSigningProfileResult>(){

            @Override
            public PutSigningProfileResult call() throws Exception {
                PutSigningProfileResult result = null;
                try {
                    result = AWSsignerAsyncClient.this.executePutSigningProfile(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RemoveProfilePermissionResult> removeProfilePermissionAsync(RemoveProfilePermissionRequest request) {
        return this.removeProfilePermissionAsync(request, null);
    }

    @Override
    public Future<RemoveProfilePermissionResult> removeProfilePermissionAsync(RemoveProfilePermissionRequest request, final AsyncHandler<RemoveProfilePermissionRequest, RemoveProfilePermissionResult> asyncHandler) {
        final RemoveProfilePermissionRequest finalRequest = (RemoveProfilePermissionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<RemoveProfilePermissionResult>(){

            @Override
            public RemoveProfilePermissionResult call() throws Exception {
                RemoveProfilePermissionResult result = null;
                try {
                    result = AWSsignerAsyncClient.this.executeRemoveProfilePermission(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RevokeSignatureResult> revokeSignatureAsync(RevokeSignatureRequest request) {
        return this.revokeSignatureAsync(request, null);
    }

    @Override
    public Future<RevokeSignatureResult> revokeSignatureAsync(RevokeSignatureRequest request, final AsyncHandler<RevokeSignatureRequest, RevokeSignatureResult> asyncHandler) {
        final RevokeSignatureRequest finalRequest = (RevokeSignatureRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<RevokeSignatureResult>(){

            @Override
            public RevokeSignatureResult call() throws Exception {
                RevokeSignatureResult result = null;
                try {
                    result = AWSsignerAsyncClient.this.executeRevokeSignature(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RevokeSigningProfileResult> revokeSigningProfileAsync(RevokeSigningProfileRequest request) {
        return this.revokeSigningProfileAsync(request, null);
    }

    @Override
    public Future<RevokeSigningProfileResult> revokeSigningProfileAsync(RevokeSigningProfileRequest request, final AsyncHandler<RevokeSigningProfileRequest, RevokeSigningProfileResult> asyncHandler) {
        final RevokeSigningProfileRequest finalRequest = (RevokeSigningProfileRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<RevokeSigningProfileResult>(){

            @Override
            public RevokeSigningProfileResult call() throws Exception {
                RevokeSigningProfileResult result = null;
                try {
                    result = AWSsignerAsyncClient.this.executeRevokeSigningProfile(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartSigningJobResult> startSigningJobAsync(StartSigningJobRequest request) {
        return this.startSigningJobAsync(request, null);
    }

    @Override
    public Future<StartSigningJobResult> startSigningJobAsync(StartSigningJobRequest request, final AsyncHandler<StartSigningJobRequest, StartSigningJobResult> asyncHandler) {
        final StartSigningJobRequest finalRequest = (StartSigningJobRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StartSigningJobResult>(){

            @Override
            public StartSigningJobResult call() throws Exception {
                StartSigningJobResult result = null;
                try {
                    result = AWSsignerAsyncClient.this.executeStartSigningJob(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {
        return this.tagResourceAsync(request, null);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request, final AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {
        final TagResourceRequest finalRequest = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TagResourceResult>(){

            @Override
            public TagResourceResult call() throws Exception {
                TagResourceResult result = null;
                try {
                    result = AWSsignerAsyncClient.this.executeTagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {
        return this.untagResourceAsync(request, null);
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request, final AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {
        final UntagResourceRequest finalRequest = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UntagResourceResult>(){

            @Override
            public UntagResourceResult call() throws Exception {
                UntagResourceResult result = null;
                try {
                    result = AWSsignerAsyncClient.this.executeUntagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

