/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.textract.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.textract.model.DocumentGroup;
import com.amazonaws.services.textract.model.transform.LendingSummaryMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class LendingSummary
implements Serializable,
Cloneable,
StructuredPojo {
    private List<DocumentGroup> documentGroups;
    private List<String> undetectedDocumentTypes;

    public List<DocumentGroup> getDocumentGroups() {
        return this.documentGroups;
    }

    public void setDocumentGroups(Collection<DocumentGroup> documentGroups) {
        if (documentGroups == null) {
            this.documentGroups = null;
            return;
        }
        this.documentGroups = new ArrayList<DocumentGroup>(documentGroups);
    }

    public LendingSummary withDocumentGroups(DocumentGroup ... documentGroups) {
        if (this.documentGroups == null) {
            this.setDocumentGroups(new ArrayList<DocumentGroup>(documentGroups.length));
        }
        for (DocumentGroup ele : documentGroups) {
            this.documentGroups.add(ele);
        }
        return this;
    }

    public LendingSummary withDocumentGroups(Collection<DocumentGroup> documentGroups) {
        this.setDocumentGroups(documentGroups);
        return this;
    }

    public List<String> getUndetectedDocumentTypes() {
        return this.undetectedDocumentTypes;
    }

    public void setUndetectedDocumentTypes(Collection<String> undetectedDocumentTypes) {
        if (undetectedDocumentTypes == null) {
            this.undetectedDocumentTypes = null;
            return;
        }
        this.undetectedDocumentTypes = new ArrayList<String>(undetectedDocumentTypes);
    }

    public LendingSummary withUndetectedDocumentTypes(String ... undetectedDocumentTypes) {
        if (this.undetectedDocumentTypes == null) {
            this.setUndetectedDocumentTypes(new ArrayList<String>(undetectedDocumentTypes.length));
        }
        for (String ele : undetectedDocumentTypes) {
            this.undetectedDocumentTypes.add(ele);
        }
        return this;
    }

    public LendingSummary withUndetectedDocumentTypes(Collection<String> undetectedDocumentTypes) {
        this.setUndetectedDocumentTypes(undetectedDocumentTypes);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDocumentGroups() != null) {
            sb.append("DocumentGroups: ").append(this.getDocumentGroups()).append(",");
        }
        if (this.getUndetectedDocumentTypes() != null) {
            sb.append("UndetectedDocumentTypes: ").append(this.getUndetectedDocumentTypes());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LendingSummary)) {
            return false;
        }
        LendingSummary other = (LendingSummary)obj;
        if (other.getDocumentGroups() == null ^ this.getDocumentGroups() == null) {
            return false;
        }
        if (other.getDocumentGroups() != null && !other.getDocumentGroups().equals(this.getDocumentGroups())) {
            return false;
        }
        if (other.getUndetectedDocumentTypes() == null ^ this.getUndetectedDocumentTypes() == null) {
            return false;
        }
        return other.getUndetectedDocumentTypes() == null || other.getUndetectedDocumentTypes().equals(this.getUndetectedDocumentTypes());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDocumentGroups() == null ? 0 : this.getDocumentGroups().hashCode());
        hashCode = 31 * hashCode + (this.getUndetectedDocumentTypes() == null ? 0 : this.getUndetectedDocumentTypes().hashCode());
        return hashCode;
    }

    public LendingSummary clone() {
        try {
            return (LendingSummary)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LendingSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

