/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.textract.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.textract.model.Geometry;
import com.amazonaws.services.textract.model.SelectionStatus;
import com.amazonaws.services.textract.model.transform.LendingDetectionMarshaller;
import java.io.Serializable;

public class LendingDetection
implements Serializable,
Cloneable,
StructuredPojo {
    private String text;
    private String selectionStatus;
    private Geometry geometry;
    private Float confidence;

    public void setText(String text) {
        this.text = text;
    }

    public String getText() {
        return this.text;
    }

    public LendingDetection withText(String text) {
        this.setText(text);
        return this;
    }

    public void setSelectionStatus(String selectionStatus) {
        this.selectionStatus = selectionStatus;
    }

    public String getSelectionStatus() {
        return this.selectionStatus;
    }

    public LendingDetection withSelectionStatus(String selectionStatus) {
        this.setSelectionStatus(selectionStatus);
        return this;
    }

    public LendingDetection withSelectionStatus(SelectionStatus selectionStatus) {
        this.selectionStatus = selectionStatus.toString();
        return this;
    }

    public void setGeometry(Geometry geometry) {
        this.geometry = geometry;
    }

    public Geometry getGeometry() {
        return this.geometry;
    }

    public LendingDetection withGeometry(Geometry geometry) {
        this.setGeometry(geometry);
        return this;
    }

    public void setConfidence(Float confidence) {
        this.confidence = confidence;
    }

    public Float getConfidence() {
        return this.confidence;
    }

    public LendingDetection withConfidence(Float confidence) {
        this.setConfidence(confidence);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getText() != null) {
            sb.append("Text: ").append(this.getText()).append(",");
        }
        if (this.getSelectionStatus() != null) {
            sb.append("SelectionStatus: ").append(this.getSelectionStatus()).append(",");
        }
        if (this.getGeometry() != null) {
            sb.append("Geometry: ").append(this.getGeometry()).append(",");
        }
        if (this.getConfidence() != null) {
            sb.append("Confidence: ").append(this.getConfidence());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LendingDetection)) {
            return false;
        }
        LendingDetection other = (LendingDetection)obj;
        if (other.getText() == null ^ this.getText() == null) {
            return false;
        }
        if (other.getText() != null && !other.getText().equals(this.getText())) {
            return false;
        }
        if (other.getSelectionStatus() == null ^ this.getSelectionStatus() == null) {
            return false;
        }
        if (other.getSelectionStatus() != null && !other.getSelectionStatus().equals(this.getSelectionStatus())) {
            return false;
        }
        if (other.getGeometry() == null ^ this.getGeometry() == null) {
            return false;
        }
        if (other.getGeometry() != null && !other.getGeometry().equals(this.getGeometry())) {
            return false;
        }
        if (other.getConfidence() == null ^ this.getConfidence() == null) {
            return false;
        }
        return other.getConfidence() == null || other.getConfidence().equals(this.getConfidence());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getText() == null ? 0 : this.getText().hashCode());
        hashCode = 31 * hashCode + (this.getSelectionStatus() == null ? 0 : this.getSelectionStatus().hashCode());
        hashCode = 31 * hashCode + (this.getGeometry() == null ? 0 : this.getGeometry().hashCode());
        hashCode = 31 * hashCode + (this.getConfidence() == null ? 0 : this.getConfidence().hashCode());
        return hashCode;
    }

    public LendingDetection clone() {
        try {
            return (LendingDetection)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LendingDetectionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

