/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.transfer.model;

import com.amazonaws.AmazonWebServiceRequest;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class StartFileTransferRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String connectorId;
    private List<String> sendFilePaths;
    private List<String> retrieveFilePaths;
    private String localDirectoryPath;
    private String remoteDirectoryPath;

    public void setConnectorId(String connectorId) {
        this.connectorId = connectorId;
    }

    public String getConnectorId() {
        return this.connectorId;
    }

    public StartFileTransferRequest withConnectorId(String connectorId) {
        this.setConnectorId(connectorId);
        return this;
    }

    public List<String> getSendFilePaths() {
        return this.sendFilePaths;
    }

    public void setSendFilePaths(Collection<String> sendFilePaths) {
        if (sendFilePaths == null) {
            this.sendFilePaths = null;
            return;
        }
        this.sendFilePaths = new ArrayList<String>(sendFilePaths);
    }

    public StartFileTransferRequest withSendFilePaths(String ... sendFilePaths) {
        if (this.sendFilePaths == null) {
            this.setSendFilePaths(new ArrayList<String>(sendFilePaths.length));
        }
        for (String ele : sendFilePaths) {
            this.sendFilePaths.add(ele);
        }
        return this;
    }

    public StartFileTransferRequest withSendFilePaths(Collection<String> sendFilePaths) {
        this.setSendFilePaths(sendFilePaths);
        return this;
    }

    public List<String> getRetrieveFilePaths() {
        return this.retrieveFilePaths;
    }

    public void setRetrieveFilePaths(Collection<String> retrieveFilePaths) {
        if (retrieveFilePaths == null) {
            this.retrieveFilePaths = null;
            return;
        }
        this.retrieveFilePaths = new ArrayList<String>(retrieveFilePaths);
    }

    public StartFileTransferRequest withRetrieveFilePaths(String ... retrieveFilePaths) {
        if (this.retrieveFilePaths == null) {
            this.setRetrieveFilePaths(new ArrayList<String>(retrieveFilePaths.length));
        }
        for (String ele : retrieveFilePaths) {
            this.retrieveFilePaths.add(ele);
        }
        return this;
    }

    public StartFileTransferRequest withRetrieveFilePaths(Collection<String> retrieveFilePaths) {
        this.setRetrieveFilePaths(retrieveFilePaths);
        return this;
    }

    public void setLocalDirectoryPath(String localDirectoryPath) {
        this.localDirectoryPath = localDirectoryPath;
    }

    public String getLocalDirectoryPath() {
        return this.localDirectoryPath;
    }

    public StartFileTransferRequest withLocalDirectoryPath(String localDirectoryPath) {
        this.setLocalDirectoryPath(localDirectoryPath);
        return this;
    }

    public void setRemoteDirectoryPath(String remoteDirectoryPath) {
        this.remoteDirectoryPath = remoteDirectoryPath;
    }

    public String getRemoteDirectoryPath() {
        return this.remoteDirectoryPath;
    }

    public StartFileTransferRequest withRemoteDirectoryPath(String remoteDirectoryPath) {
        this.setRemoteDirectoryPath(remoteDirectoryPath);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getConnectorId() != null) {
            sb.append("ConnectorId: ").append(this.getConnectorId()).append(",");
        }
        if (this.getSendFilePaths() != null) {
            sb.append("SendFilePaths: ").append(this.getSendFilePaths()).append(",");
        }
        if (this.getRetrieveFilePaths() != null) {
            sb.append("RetrieveFilePaths: ").append(this.getRetrieveFilePaths()).append(",");
        }
        if (this.getLocalDirectoryPath() != null) {
            sb.append("LocalDirectoryPath: ").append(this.getLocalDirectoryPath()).append(",");
        }
        if (this.getRemoteDirectoryPath() != null) {
            sb.append("RemoteDirectoryPath: ").append(this.getRemoteDirectoryPath());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartFileTransferRequest)) {
            return false;
        }
        StartFileTransferRequest other = (StartFileTransferRequest)obj;
        if (other.getConnectorId() == null ^ this.getConnectorId() == null) {
            return false;
        }
        if (other.getConnectorId() != null && !other.getConnectorId().equals(this.getConnectorId())) {
            return false;
        }
        if (other.getSendFilePaths() == null ^ this.getSendFilePaths() == null) {
            return false;
        }
        if (other.getSendFilePaths() != null && !other.getSendFilePaths().equals(this.getSendFilePaths())) {
            return false;
        }
        if (other.getRetrieveFilePaths() == null ^ this.getRetrieveFilePaths() == null) {
            return false;
        }
        if (other.getRetrieveFilePaths() != null && !other.getRetrieveFilePaths().equals(this.getRetrieveFilePaths())) {
            return false;
        }
        if (other.getLocalDirectoryPath() == null ^ this.getLocalDirectoryPath() == null) {
            return false;
        }
        if (other.getLocalDirectoryPath() != null && !other.getLocalDirectoryPath().equals(this.getLocalDirectoryPath())) {
            return false;
        }
        if (other.getRemoteDirectoryPath() == null ^ this.getRemoteDirectoryPath() == null) {
            return false;
        }
        return other.getRemoteDirectoryPath() == null || other.getRemoteDirectoryPath().equals(this.getRemoteDirectoryPath());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getConnectorId() == null ? 0 : this.getConnectorId().hashCode());
        hashCode = 31 * hashCode + (this.getSendFilePaths() == null ? 0 : this.getSendFilePaths().hashCode());
        hashCode = 31 * hashCode + (this.getRetrieveFilePaths() == null ? 0 : this.getRetrieveFilePaths().hashCode());
        hashCode = 31 * hashCode + (this.getLocalDirectoryPath() == null ? 0 : this.getLocalDirectoryPath().hashCode());
        hashCode = 31 * hashCode + (this.getRemoteDirectoryPath() == null ? 0 : this.getRemoteDirectoryPath().hashCode());
        return hashCode;
    }

    public StartFileTransferRequest clone() {
        return (StartFileTransferRequest)super.clone();
    }
}

