/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.util;

import com.amazonaws.util.ClassLoaderHelper;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.annotation.ThreadSafe;

@ThreadSafe
public class VersionInfoUtils {
    static final String VERSION_INFO_FILE = "/com/amazonaws/sdk/versionInfo.properties";
    private static volatile String version;
    private static volatile String platform;
    private static volatile String userAgent;
    private static final Log log;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getVersion() {
        if (version != null) return version;
        Class<VersionInfoUtils> clazz = VersionInfoUtils.class;
        synchronized (VersionInfoUtils.class) {
            if (version != null) return version;
            VersionInfoUtils.initializeVersion();
            // ** MonitorExit[var0] (shouldn't be in output)
            return version;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getPlatform() {
        if (platform != null) return platform;
        Class<VersionInfoUtils> clazz = VersionInfoUtils.class;
        synchronized (VersionInfoUtils.class) {
            if (platform != null) return platform;
            VersionInfoUtils.initializeVersion();
            // ** MonitorExit[var0] (shouldn't be in output)
            return platform;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getUserAgent() {
        if (userAgent != null) return userAgent;
        Class<VersionInfoUtils> clazz = VersionInfoUtils.class;
        synchronized (VersionInfoUtils.class) {
            if (userAgent != null) return userAgent;
            VersionInfoUtils.initializeUserAgent();
            // ** MonitorExit[var0] (shouldn't be in output)
            return userAgent;
        }
    }

    private static void initializeVersion() {
        InputStream inputStream = ClassLoaderHelper.getResourceAsStream(VERSION_INFO_FILE, true, VersionInfoUtils.class);
        Properties versionInfoProperties = new Properties();
        try {
            if (inputStream == null) {
                throw new Exception("/com/amazonaws/sdk/versionInfo.properties not found on classpath");
            }
            versionInfoProperties.load(inputStream);
            version = versionInfoProperties.getProperty("version");
            platform = versionInfoProperties.getProperty("platform");
        }
        catch (Exception e) {
            log.info((Object)("Unable to load version information for the running SDK: " + e.getMessage()));
            version = "unknown-version";
            platform = "java";
        }
        finally {
            try {
                inputStream.close();
            }
            catch (Exception exception) {}
        }
    }

    private static void initializeUserAgent() {
        userAgent = VersionInfoUtils.userAgent();
    }

    static String userAgent() {
        StringBuilder buffer = new StringBuilder(128);
        buffer.append("aws-sdk-");
        buffer.append(VersionInfoUtils.getPlatform().toLowerCase());
        buffer.append("/");
        buffer.append(VersionInfoUtils.getVersion());
        buffer.append(" ");
        buffer.append(VersionInfoUtils.replaceSpaces(System.getProperty("os.name")));
        buffer.append("/");
        buffer.append(VersionInfoUtils.replaceSpaces(System.getProperty("os.version")));
        buffer.append(" ");
        buffer.append(VersionInfoUtils.replaceSpaces(System.getProperty("java.vm.name")));
        buffer.append("/");
        buffer.append(VersionInfoUtils.replaceSpaces(System.getProperty("java.vm.version")));
        buffer.append("/");
        buffer.append(VersionInfoUtils.replaceSpaces(System.getProperty("java.version")));
        String language = System.getProperty("user.language");
        String region = System.getProperty("user.region");
        if (language != null && region != null) {
            buffer.append(" ");
            buffer.append(VersionInfoUtils.replaceSpaces(language));
            buffer.append("_");
            buffer.append(VersionInfoUtils.replaceSpaces(region));
        }
        return buffer.toString();
    }

    private static String replaceSpaces(String input) {
        return input.replace(' ', '_');
    }

    static {
        log = LogFactory.getLog(VersionInfoUtils.class);
    }
}

