/*
 * Copyright 2010-2014 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License").
 * You may not use this file except in compliance with the License.
 * A copy of the License is located at
 * 
 *  http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed
 * on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language governing
 * permissions and limitations under the License.
 */

package com.amazonaws.services.cloudfront.model.transform;

import java.util.Map;
import java.util.Map.Entry;

import javax.xml.stream.events.XMLEvent;

import com.amazonaws.services.cloudfront.model.*;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.transform.MapEntry;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * Create Streaming Distribution Result StAX Unmarshaller
 */
public class CreateStreamingDistributionResultStaxUnmarshaller implements Unmarshaller<CreateStreamingDistributionResult, StaxUnmarshallerContext> {

    public CreateStreamingDistributionResult unmarshall(StaxUnmarshallerContext context) throws Exception {
        CreateStreamingDistributionResult createStreamingDistributionResult = new CreateStreamingDistributionResult();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument()) {
            createStreamingDistributionResult.setLocation(context.getHeader("Location"));
            createStreamingDistributionResult.setETag(context.getHeader("ETag"));
        }

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) return createStreamingDistributionResult;

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("StreamingDistribution", targetDepth)) {
                    createStreamingDistributionResult.setStreamingDistribution(StreamingDistributionStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    return createStreamingDistributionResult;
                }
            }
        }
    }

    private static CreateStreamingDistributionResultStaxUnmarshaller instance;
    public static CreateStreamingDistributionResultStaxUnmarshaller getInstance() {
        if (instance == null) instance = new CreateStreamingDistributionResultStaxUnmarshaller();
        return instance;
    }
}
    