/*
 * Decompiled with CFR 0.152.
 */
package com.axisj.axu4j.config;

import com.axisj.axu4j.config.AXUConfig;
import java.io.File;
import java.net.URL;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.simpleframework.xml.core.Persister;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigReader {
    private static final Logger logger = LoggerFactory.getLogger(ConfigReader.class);
    private static final String defaultConfigFilename = "axu4j.xml";
    private static AXUConfig config = null;
    private static long lastLoadTime = -1L;

    private ConfigReader() {
    }

    public static AXUConfig getConfig() {
        if (config == null || StringUtils.equalsIgnoreCase((String)"DEV", (String)config.getMode())) {
            ConfigReader.load();
        }
        return config;
    }

    public static void load(String confingFilename) {
        try {
            long nowTime;
            if (config == null) {
                config = new AXUConfig();
                logger.debug("create new AXUConfig instance");
            }
            if ((nowTime = new Date().getTime()) - lastLoadTime < 3000L) {
                return;
            }
            lastLoadTime = nowTime;
            Persister serializer = new Persister();
            URL configUrl = config.getClass().getClassLoader().getResource(confingFilename);
            if (configUrl == null) {
                configUrl = ClassLoader.getSystemClassLoader().getResource(confingFilename);
            }
            File configFile = new File(configUrl.toURI());
            serializer.read((Object)config, configFile);
            logger.info("load config from {}", (Object)configFile.getAbsolutePath());
            if (logger.isDebugEnabled()) {
                logger.debug("axu4j.xml\n{}", (Object)config);
            }
        }
        catch (Exception e) {
            logger.error("Fail to load axu4j.xml", (Throwable)e);
        }
    }

    public static void load() {
        ConfigReader.load(defaultConfigFilename);
    }

    public static void save(String confingFilename) throws Exception {
        Persister serializer = new Persister();
        File configFile = new File(ClassLoader.getSystemClassLoader().getResource(confingFilename).toURI());
        serializer.write((Object)config, configFile);
        logger.debug("save config to {}", (Object)configFile.getAbsolutePath());
    }

    public static void save() throws Exception {
        ConfigReader.save(defaultConfigFilename);
    }
}

