/*
 * Decompiled with CFR 0.152.
 */
package com.axisj.axu4j.tags;

import com.axisj.axu4j.config.AXUConfig;
import com.axisj.axu4j.config.ConfigReader;
import com.axisj.axu4j.tags.CustomTag;
import com.axisj.axu4j.tags.TagUtils;
import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import com.github.mustachejava.MustacheFactory;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.jsp.JspContext;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.DynamicAttributes;
import javax.servlet.jsp.tagext.JspFragment;
import javax.servlet.jsp.tagext.SimpleTagSupport;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AXUTagSupport
extends SimpleTagSupport
implements DynamicAttributes {
    protected static MustacheFactory mustacheFactory = new DefaultMustacheFactory();
    protected static int tagIndex = 0;
    protected Mustache mustacheHtml;
    protected Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected String tagBody = "";
    protected String doBody = "";
    protected Map<String, Object> innerInstance = new LinkedHashMap<String, Object>();
    protected Map<String, Object> dynamicAttrMap = new LinkedHashMap<String, Object>();
    private static final Map<String, Mustache> mustacheCacheMap = new HashMap<String, Mustache>();

    public AXUTagSupport() throws Exception {
        ++tagIndex;
    }

    public String getDoBody() {
        return this.doBody;
    }

    public void setDoBody(String doBody) {
        this.doBody = doBody;
    }

    public void setDynamicAttribute(String uri, String localName, Object value) throws JspException {
        if (TagUtils.isELValue(value)) {
            value = TagUtils.getElValue(this.getJspContext(), TagUtils.getElName(value));
        }
        this.dynamicAttrMap.put(localName, value);
    }

    public void doTag() throws JspException, IOException {
        try {
            JspContext context = this.getJspContext();
            JspFragment fragment = this.getJspBody();
            PageContext pageContext = (PageContext)context;
            this.beforeDoTag(context, fragment);
            this.innerInstance.put("param", TagUtils.getRequestParameterMap(pageContext));
            this.innerInstance.put("request", TagUtils.getRequestAttributeMap(pageContext));
            this.innerInstance.put("session", TagUtils.getSessionAttributeMap(pageContext));
            this.innerInstance.put("cookie", TagUtils.getCookieMap(pageContext));
            this.innerInstance.putAll(this.dynamicAttrMap);
            Object[] params = new Object[]{this, this.innerInstance};
            String mustacheKey = ((Object)((Object)this)).getClass().getCanonicalName();
            AXUConfig config = ConfigReader.getConfig();
            if (this instanceof CustomTag) {
                CustomTag customTag = (CustomTag)this;
                mustacheKey = mustacheKey + "#" + customTag.getCustomid();
            }
            this.mustacheHtml = mustacheCacheMap.get(mustacheKey);
            if (this.mustacheHtml == null) {
                if (this.tagBody == null) {
                    throw new RuntimeException("tag body is empty. please check your aux4j.xml");
                }
                this.mustacheHtml = mustacheFactory.compile((Reader)new StringReader(this.tagBody), mustacheKey);
                if (!StringUtils.equalsIgnoreCase((String)"DEV", (String)config.getMode())) {
                    mustacheCacheMap.put(mustacheKey, this.mustacheHtml);
                }
            }
            this.mustacheHtml.execute((Writer)context.getOut(), params);
            this.afterDoTag(context, fragment);
        }
        catch (Exception e) {
            this.logger.error(String.format("doTag is fail.\ntagBody: %s\nmustacheHtml: %s", this.tagBody, this.mustacheHtml == null ? "null" : this.mustacheHtml.toString()), (Throwable)e);
        }
    }

    public String toString() {
        if (this.mustacheHtml == null) {
            return "";
        }
        return this.mustacheHtml.execute((Writer)new StringWriter(), (Object)this).toString();
    }

    public abstract void beforeDoTag(JspContext var1, JspFragment var2) throws IOException;

    public abstract void afterDoTag(JspContext var1, JspFragment var2);
}

