/*
 * Decompiled with CFR 0.152.
 */
package com.axisj.axu4j.tags;

import com.axisj.axu4j.config.AXUConfig;
import com.axisj.axu4j.config.ConfigReader;
import com.axisj.axu4j.tags.TagUtils;
import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import com.github.mustachejava.MustacheFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.SimpleTagSupport;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LayoutTag
extends SimpleTagSupport {
    protected static MustacheFactory mustacheFactory = new DefaultMustacheFactory();
    private static final String HEADER_KEY_PJAX = "X-PJAX";
    private static final String HEADER_KEY_AXU4J_DIV = "X-AXU4J-DIV";
    protected Mustache mustacheHtml;
    protected Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private Hashtable<String, String> divMap = new Hashtable();
    private Map<String, Object> globalMap = new HashMap<String, Object>();
    private String name;
    private String key;

    public void doTag() throws JspException, IOException {
        PageContext pageContext = (PageContext)this.getJspContext();
        HttpServletRequest request = (HttpServletRequest)pageContext.getRequest();
        this.globalMap.put("__AXU4J_CONTEXT_PATH__", request.getContextPath());
        StringWriter dummy = new StringWriter();
        this.getJspBody().invoke((Writer)dummy);
        boolean isPjax = BooleanUtils.toBoolean((String)ObjectUtils.toString((Object)request.getHeader(HEADER_KEY_PJAX)));
        if (isPjax) {
            String[] divs;
            JspWriter out = pageContext.getOut();
            for (String div : divs = StringUtils.split((String)request.getHeader(HEADER_KEY_AXU4J_DIV), (String)",")) {
                out.write(this.divMap.get(StringUtils.trim((String)div)));
            }
            return;
        }
        AXUConfig config = ConfigReader.getConfig();
        String layoutFilename = this.getLayoutFilename();
        Reader layoutFileReader = null;
        try {
            if (StringUtils.endsWithIgnoreCase((String)layoutFilename, (String)"jsp")) {
                pageContext.getServletContext().setAttribute("divMap", this.divMap);
                pageContext.forward(layoutFilename);
            } else {
                layoutFileReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.getLayoutFile(layoutFilename)), config.getLayoutEncoding()));
                this.globalMap.put("param", TagUtils.getRequestParameterMap(pageContext));
                this.globalMap.put("request", TagUtils.getRequestAttributeMap(pageContext));
                this.globalMap.put("session", TagUtils.getSessionAttributeMap(pageContext));
                this.globalMap.put("cookie", TagUtils.getCookieMap(pageContext));
                Object[] params = new Object[]{this.divMap, this.globalMap};
                this.mustacheHtml = mustacheFactory.compile(layoutFileReader, this.key);
                this.mustacheHtml.execute((Writer)this.getJspContext().getOut(), params);
            }
        }
        catch (Exception e) {
            throw new JspException(String.format("LayoutTag is fail.\nname: %s", this.name), (Throwable)e);
        }
        finally {
            if (layoutFileReader != null) {
                layoutFileReader.close();
            }
            this.divMap = null;
        }
    }

    private String getLayoutFilename() throws JspException {
        String layoutFilename;
        String realPath;
        File realFile;
        ServletContext servletContext = ((PageContext)this.getJspContext()).getServletContext();
        AXUConfig config = ConfigReader.getConfig();
        String prefix = config.getLayoutPrefix();
        if (prefix == null) {
            prefix = "";
        }
        if (!(realFile = new File(realPath = servletContext.getRealPath(layoutFilename = prefix + this.name))).exists()) {
            throw new JspException(String.format("LayoutTag JSP File Not Found: %s", layoutFilename));
        }
        this.logger.debug("layout extends {}", (Object)layoutFilename);
        return layoutFilename;
    }

    private File getLayoutFile(String layoutFilename) throws JspException {
        ServletContext servletContext = ((PageContext)this.getJspContext()).getServletContext();
        String realPath = servletContext.getRealPath(layoutFilename);
        File realFile = new File(realPath);
        if (!realFile.exists()) {
            throw new JspException(String.format("LayoutTag File Not Found: %s", layoutFilename));
        }
        this.logger.debug("layout {}", (Object)layoutFilename);
        return realFile;
    }

    public String getDiv(String key) {
        return this.divMap.get(key);
    }

    public void putDiv(String key, String value) {
        this.divMap.put(key, value);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.key = LayoutTag.class.getCanonicalName() + "." + name;
    }
}

