/*
 * Decompiled with CFR 0.152.
 */
package com.axisj.axu4j.tags;

import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspContext;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.el.ELException;
import javax.servlet.jsp.el.VariableResolver;
import javax.servlet.jsp.tagext.JspFragment;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TagUtils {
    public static Logger logger = LoggerFactory.getLogger(TagUtils.class);
    public static final String EL_PREFIX = "${";
    public static final String EL_SUFFIX = "}";

    public static String toString(JspFragment jspFrag) {
        if (jspFrag == null) {
            return null;
        }
        StringWriter writer = new StringWriter();
        try {
            jspFrag.invoke((Writer)writer);
        }
        catch (Exception e) {
            logger.error("getJspContents is fail.", (Throwable)e);
        }
        return writer.toString();
    }

    public static boolean isELValue(Object value) {
        String elVal = ObjectUtils.toString((Object)value);
        elVal = StringUtils.trim((String)elVal);
        return StringUtils.startsWith((String)elVal, (String)EL_PREFIX);
    }

    public static String getElName(Object value) {
        String elVal = ObjectUtils.toString((Object)value);
        elVal = StringUtils.removeStart((String)elVal, (String)EL_PREFIX);
        elVal = StringUtils.removeEnd((String)elVal, (String)EL_SUFFIX);
        return elVal;
    }

    public static Object getElValue(JspContext context, String elName) {
        VariableResolver variableResolver = context.getVariableResolver();
        Object var = null;
        try {
            elName = TagUtils.getElName(elName);
            var = variableResolver.resolveVariable(elName);
            logger.debug("ExpressionLanguage variable {} is [{}]", (Object)elName, var);
        }
        catch (ELException e) {
            logger.error("ExpressionLanguage Error", (Throwable)e);
        }
        return var;
    }

    public static String getCookieValue(Object value) {
        String strVal = ObjectUtils.toString((Object)value);
        try {
            strVal = URLEncoder.encode(strVal, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return strVal;
    }

    public static Map<String, Object> getRequestParameterMap(PageContext pageContext) {
        LinkedHashMap<String, Object> requestParameterMap = new LinkedHashMap<String, Object>();
        HttpServletRequest request = (HttpServletRequest)pageContext.getRequest();
        Enumeration reqParams = request.getParameterNames();
        while (reqParams.hasMoreElements()) {
            String attrName = (String)reqParams.nextElement();
            String[] values = request.getParameterValues(attrName);
            if (values.length == 1) {
                requestParameterMap.put(attrName, values[0]);
                continue;
            }
            requestParameterMap.put(attrName, values);
        }
        return requestParameterMap;
    }

    public static Map<String, Object> getRequestAttributeMap(PageContext pageContext) {
        LinkedHashMap<String, Object> requestAttributeMap = new LinkedHashMap<String, Object>();
        HttpServletRequest request = (HttpServletRequest)pageContext.getRequest();
        Enumeration reqAttrs = request.getAttributeNames();
        while (reqAttrs.hasMoreElements()) {
            String attrName = (String)reqAttrs.nextElement();
            requestAttributeMap.put(attrName, request.getAttribute(attrName));
        }
        return requestAttributeMap;
    }

    public static Map<String, Object> getSessionAttributeMap(PageContext pageContext) {
        LinkedHashMap<String, Object> sessionAttributeMap = new LinkedHashMap<String, Object>();
        HttpServletRequest request = (HttpServletRequest)pageContext.getRequest();
        HttpSession session = request.getSession();
        Enumeration sesAttrs = request.getSession().getAttributeNames();
        while (sesAttrs.hasMoreElements()) {
            String attrName = (String)sesAttrs.nextElement();
            sessionAttributeMap.put(attrName, session.getAttribute(attrName));
        }
        return sessionAttributeMap;
    }

    public static Map<String, Object> getCookieMap(PageContext pageContext) {
        LinkedHashMap<String, Object> cookieMap = new LinkedHashMap<String, Object>();
        HttpServletRequest request = (HttpServletRequest)pageContext.getRequest();
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (int ci = 0; ci < cookies.length; ++ci) {
                cookieMap.put(cookies[ci].getName(), cookies[ci].getValue());
            }
        }
        return cookieMap;
    }
}

