// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.Duration;

/**
 * Extended information about a single transcribed word, as provided on responses when the 'word' timestamp granularity
 * is provided.
 */
@Immutable
public final class AudioTranscriptionWord implements JsonSerializable<AudioTranscriptionWord> {

    /*
     * The textual content of the word.
     */
    @Generated
    private final String word;

    /*
     * The start time of the word relative to the beginning of the audio, expressed in seconds.
     */
    @Generated
    private final double start;

    /*
     * The end time of the word relative to the beginning of the audio, expressed in seconds.
     */
    @Generated
    private final double end;

    /**
     * Get the word property: The textual content of the word.
     *
     * @return the word value.
     */
    @Generated
    public String getWord() {
        return this.word;
    }

    /**
     * Get the start property: The start time of the word relative to the beginning of the audio, expressed in seconds.
     *
     * @return the start value.
     */
    @Generated
    public Duration getStart() {
        return Duration.ofNanos((long) (this.start * 1000_000_000L));
    }

    /**
     * Get the end property: The end time of the word relative to the beginning of the audio, expressed in seconds.
     *
     * @return the end value.
     */
    @Generated
    public Duration getEnd() {
        return Duration.ofNanos((long) (this.end * 1000_000_000L));
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("word", this.word);
        jsonWriter.writeDoubleField("start", this.start);
        jsonWriter.writeDoubleField("end", this.end);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AudioTranscriptionWord from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of AudioTranscriptionWord if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the AudioTranscriptionWord.
     */
    @Generated
    public static AudioTranscriptionWord fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String word = null;
            Duration start = null;
            Duration end = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("word".equals(fieldName)) {
                    word = reader.getString();
                } else if ("start".equals(fieldName)) {
                    start = Duration.ofNanos((long) (reader.getDouble() * 1000_000_000L));
                } else if ("end".equals(fieldName)) {
                    end = Duration.ofNanos((long) (reader.getDouble() * 1000_000_000L));
                } else {
                    reader.skipChildren();
                }
            }
            return new AudioTranscriptionWord(word, start, end);
        });
    }

    /**
     * Creates an instance of AudioTranscriptionWord class.
     *
     * @param word the word value to set.
     * @param start the start value to set.
     * @param end the end value to set.
     */
    @Generated
    private AudioTranscriptionWord(String word, Duration start, Duration end) {
        this.word = word;
        if (start == null) {
            this.start = 0.0;
        } else {
            this.start = (double) start.toNanos() / 1000_000_000L;
        }
        if (end == null) {
            this.end = 0.0;
        } else {
            this.end = (double) end.toNanos() / 1000_000_000L;
        }
    }
}
