// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.

package com.azure.ai.openai.models;

/**
 * The reason for filtering the retrieved document.
 */
public enum AzureChatExtensionRetrieveDocumentFilterReason {
    /**
     * The document is filtered by original search score threshold defined by `strictness` configure.
     */
    SCORE("score"),

    /**
     * The document is not filtered by original search score threshold, but is filtered by rerank score and
     * `top_n_documents` configure.
     */
    RERANK("rerank");

    /**
     * The actual serialized value for a AzureChatExtensionRetrieveDocumentFilterReason instance.
     */
    private final String value;

    AzureChatExtensionRetrieveDocumentFilterReason(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a AzureChatExtensionRetrieveDocumentFilterReason instance.
     * 
     * @param value the serialized value to parse.
     * @return the parsed AzureChatExtensionRetrieveDocumentFilterReason object, or null if unable to parse.
     */
    public static AzureChatExtensionRetrieveDocumentFilterReason fromString(String value) {
        if (value == null) {
            return null;
        }
        AzureChatExtensionRetrieveDocumentFilterReason[] items
            = AzureChatExtensionRetrieveDocumentFilterReason.values();
        for (AzureChatExtensionRetrieveDocumentFilterReason item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String toString() {
        return this.value;
    }
}
