// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * A request chat message representing response or action from the assistant.
 */
@Fluent
public final class ChatRequestAssistantMessage extends ChatRequestMessage {

    /*
     * The content of the message.
     */
    @Generated
    private final String content;

    /*
     * An optional name for the participant.
     */
    @Generated
    private String name;

    /*
     * The tool calls that must be resolved and have their outputs appended to subsequent input messages for the chat
     * completions request to resolve as configured.
     */
    @Generated
    private List<ChatCompletionsToolCall> toolCalls;

    /*
     * The function call that must be resolved and have its output appended to subsequent input messages for the chat
     * completions request to resolve as configured.
     */
    @Generated
    private FunctionCall functionCall;

    /**
     * Creates an instance of ChatRequestAssistantMessage class.
     *
     * @param content the content value to set.
     */
    @Generated
    public ChatRequestAssistantMessage(String content) {
        this.content = content;
    }

    /**
     * Get the content property: The content of the message.
     *
     * @return the content value.
     */
    @Generated
    public String getContent() {
        return this.content;
    }

    /**
     * Get the name property: An optional name for the participant.
     *
     * @return the name value.
     */
    @Generated
    public String getName() {
        return this.name;
    }

    /**
     * Set the name property: An optional name for the participant.
     *
     * @param name the name value to set.
     * @return the ChatRequestAssistantMessage object itself.
     */
    @Generated
    public ChatRequestAssistantMessage setName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the toolCalls property: The tool calls that must be resolved and have their outputs appended to subsequent
     * input messages for the chat
     * completions request to resolve as configured.
     *
     * @return the toolCalls value.
     */
    @Generated
    public List<ChatCompletionsToolCall> getToolCalls() {
        return this.toolCalls;
    }

    /**
     * Set the toolCalls property: The tool calls that must be resolved and have their outputs appended to subsequent
     * input messages for the chat
     * completions request to resolve as configured.
     *
     * @param toolCalls the toolCalls value to set.
     * @return the ChatRequestAssistantMessage object itself.
     */
    @Generated
    public ChatRequestAssistantMessage setToolCalls(List<ChatCompletionsToolCall> toolCalls) {
        this.toolCalls = toolCalls;
        return this;
    }

    /**
     * Get the functionCall property: The function call that must be resolved and have its output appended to subsequent
     * input messages for the chat
     * completions request to resolve as configured.
     *
     * @return the functionCall value.
     */
    @Generated
    public FunctionCall getFunctionCall() {
        return this.functionCall;
    }

    /**
     * Set the functionCall property: The function call that must be resolved and have its output appended to subsequent
     * input messages for the chat
     * completions request to resolve as configured.
     *
     * @param functionCall the functionCall value to set.
     * @return the ChatRequestAssistantMessage object itself.
     */
    @Generated
    public ChatRequestAssistantMessage setFunctionCall(FunctionCall functionCall) {
        this.functionCall = functionCall;
        return this;
    }

    /*
     * The chat role associated with this message.
     */
    @Generated
    private ChatRole role = ChatRole.ASSISTANT;

    /**
     * Get the role property: The chat role associated with this message.
     *
     * @return the role value.
     */
    @Generated
    @Override
    public ChatRole getRole() {
        return this.role;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("content", this.content);
        jsonWriter.writeStringField("role", this.role == null ? null : this.role.toString());
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeArrayField("tool_calls", this.toolCalls, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeJsonField("function_call", this.functionCall);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ChatRequestAssistantMessage from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of ChatRequestAssistantMessage if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ChatRequestAssistantMessage.
     */
    @Generated
    public static ChatRequestAssistantMessage fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String content = null;
            ChatRole role = ChatRole.ASSISTANT;
            String name = null;
            List<ChatCompletionsToolCall> toolCalls = null;
            FunctionCall functionCall = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("content".equals(fieldName)) {
                    content = reader.getString();
                } else if ("role".equals(fieldName)) {
                    role = ChatRole.fromString(reader.getString());
                } else if ("name".equals(fieldName)) {
                    name = reader.getString();
                } else if ("tool_calls".equals(fieldName)) {
                    toolCalls = reader.readArray(reader1 -> ChatCompletionsToolCall.fromJson(reader1));
                } else if ("function_call".equals(fieldName)) {
                    functionCall = FunctionCall.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }
            ChatRequestAssistantMessage deserializedChatRequestAssistantMessage
                = new ChatRequestAssistantMessage(content);
            deserializedChatRequestAssistantMessage.role = role;
            deserializedChatRequestAssistantMessage.name = name;
            deserializedChatRequestAssistantMessage.toolCalls = toolCalls;
            deserializedChatRequestAssistantMessage.functionCall = functionCall;
            return deserializedChatRequestAssistantMessage;
        });
    }
}
