// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * A request chat message containing system instructions that influence how the model will generate a chat completions
 * response.
 */
@Fluent
public final class ChatRequestSystemMessage extends ChatRequestMessage {

    /*
     * The contents of the system message.
     */
    @Generated
    private final String content;

    /*
     * An optional name for the participant.
     */
    @Generated
    private String name;

    /**
     * Creates an instance of ChatRequestSystemMessage class.
     *
     * @param content the content value to set.
     */
    @Generated
    public ChatRequestSystemMessage(String content) {
        this.content = content;
    }

    /**
     * Get the content property: The contents of the system message.
     *
     * @return the content value.
     */
    @Generated
    public String getContent() {
        return this.content;
    }

    /**
     * Get the name property: An optional name for the participant.
     *
     * @return the name value.
     */
    @Generated
    public String getName() {
        return this.name;
    }

    /**
     * Set the name property: An optional name for the participant.
     *
     * @param name the name value to set.
     * @return the ChatRequestSystemMessage object itself.
     */
    @Generated
    public ChatRequestSystemMessage setName(String name) {
        this.name = name;
        return this;
    }

    /*
     * The chat role associated with this message.
     */
    @Generated
    private ChatRole role = ChatRole.SYSTEM;

    /**
     * Get the role property: The chat role associated with this message.
     *
     * @return the role value.
     */
    @Generated
    @Override
    public ChatRole getRole() {
        return this.role;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("content", this.content);
        jsonWriter.writeStringField("role", this.role == null ? null : this.role.toString());
        jsonWriter.writeStringField("name", this.name);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ChatRequestSystemMessage from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of ChatRequestSystemMessage if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ChatRequestSystemMessage.
     */
    @Generated
    public static ChatRequestSystemMessage fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String content = null;
            ChatRole role = ChatRole.SYSTEM;
            String name = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("content".equals(fieldName)) {
                    content = reader.getString();
                } else if ("role".equals(fieldName)) {
                    role = ChatRole.fromString(reader.getString());
                } else if ("name".equals(fieldName)) {
                    name = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }
            ChatRequestSystemMessage deserializedChatRequestSystemMessage = new ChatRequestSystemMessage(content);
            deserializedChatRequestSystemMessage.role = role;
            deserializedChatRequestSystemMessage.name = name;
            return deserializedChatRequestSystemMessage;
        });
    }
}
