// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * A representation of the log probability information for a single message content token.
 */
@Immutable
public final class ChatTokenLogProbabilityInfo implements JsonSerializable<ChatTokenLogProbabilityInfo> {

    /*
     * The message content token.
     */
    @Generated
    private final String token;

    /*
     * The log probability of the message content token.
     */
    @Generated
    private final double logprob;

    /*
     * A list of integers representing the UTF-8 bytes representation of the token. Useful in instances where characters
     * are represented by multiple tokens and their byte representations must be combined to generate the correct text
     * representation. Can be null if there is no bytes representation for the token.
     */
    @Generated
    private final List<Integer> bytes;

    /**
     * Creates an instance of ChatTokenLogProbabilityInfo class.
     *
     * @param token the token value to set.
     * @param logprob the logprob value to set.
     * @param bytes the bytes value to set.
     */
    @Generated
    private ChatTokenLogProbabilityInfo(String token, double logprob, List<Integer> bytes) {
        this.token = token;
        this.logprob = logprob;
        this.bytes = bytes;
    }

    /**
     * Get the token property: The message content token.
     *
     * @return the token value.
     */
    @Generated
    public String getToken() {
        return this.token;
    }

    /**
     * Get the logprob property: The log probability of the message content token.
     *
     * @return the logprob value.
     */
    @Generated
    public double getLogprob() {
        return this.logprob;
    }

    /**
     * Get the bytes property: A list of integers representing the UTF-8 bytes representation of the token. Useful in
     * instances where characters are represented by multiple tokens and their byte representations must be combined to
     * generate the correct text representation. Can be null if there is no bytes representation for the token.
     *
     * @return the bytes value.
     */
    @Generated
    public List<Integer> getBytes() {
        return this.bytes;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("token", this.token);
        jsonWriter.writeDoubleField("logprob", this.logprob);
        jsonWriter.writeArrayField("bytes", this.bytes, (writer, element) -> writer.writeInt(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ChatTokenLogProbabilityInfo from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of ChatTokenLogProbabilityInfo if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ChatTokenLogProbabilityInfo.
     */
    @Generated
    public static ChatTokenLogProbabilityInfo fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String token = null;
            double logprob = 0.0;
            List<Integer> bytes = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("token".equals(fieldName)) {
                    token = reader.getString();
                } else if ("logprob".equals(fieldName)) {
                    logprob = reader.getDouble();
                } else if ("bytes".equals(fieldName)) {
                    bytes = reader.readArray(reader1 -> reader1.getInt());
                } else {
                    reader.skipChildren();
                }
            }
            return new ChatTokenLogProbabilityInfo(token, logprob, bytes);
        });
    }
}
