// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Represents the outcome of a detection operation against protected resources as performed by content filtering.
 */
@Immutable
public final class ContentFilterCitedDetectionResult implements JsonSerializable<ContentFilterCitedDetectionResult> {

    /*
     * A value indicating whether or not the content has been filtered.
     */
    @Generated
    private final boolean filtered;

    /*
     * A value indicating whether detection occurred, irrespective of severity or whether the content was filtered.
     */
    @Generated
    private final boolean detected;

    /*
     * The internet location associated with the detection.
     */
    @Generated
    private String url;

    /*
     * The license description associated with the detection.
     */
    @Generated
    private final String license;

    /**
     * Creates an instance of ContentFilterCitedDetectionResult class.
     *
     * @param filtered the filtered value to set.
     * @param detected the detected value to set.
     * @param license the license value to set.
     */
    @Generated
    private ContentFilterCitedDetectionResult(boolean filtered, boolean detected, String license) {
        this.filtered = filtered;
        this.detected = detected;
        this.license = license;
    }

    /**
     * Get the filtered property: A value indicating whether or not the content has been filtered.
     *
     * @return the filtered value.
     */
    @Generated
    public boolean isFiltered() {
        return this.filtered;
    }

    /**
     * Get the detected property: A value indicating whether detection occurred, irrespective of severity or whether the
     * content was filtered.
     *
     * @return the detected value.
     */
    @Generated
    public boolean isDetected() {
        return this.detected;
    }

    /**
     * Get the url property: The internet location associated with the detection.
     *
     * @return the url value.
     */
    @Generated
    public String getUrl() {
        return this.url;
    }

    /**
     * Get the license property: The license description associated with the detection.
     *
     * @return the license value.
     */
    @Generated
    public String getLicense() {
        return this.license;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("filtered", this.filtered);
        jsonWriter.writeBooleanField("detected", this.detected);
        jsonWriter.writeStringField("license", this.license);
        jsonWriter.writeStringField("URL", this.url);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ContentFilterCitedDetectionResult from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of ContentFilterCitedDetectionResult if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ContentFilterCitedDetectionResult.
     */
    @Generated
    public static ContentFilterCitedDetectionResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            boolean filtered = false;
            boolean detected = false;
            String license = null;
            String url = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("filtered".equals(fieldName)) {
                    filtered = reader.getBoolean();
                } else if ("detected".equals(fieldName)) {
                    detected = reader.getBoolean();
                } else if ("license".equals(fieldName)) {
                    license = reader.getString();
                } else if ("URL".equals(fieldName)) {
                    url = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }
            ContentFilterCitedDetectionResult deserializedContentFilterCitedDetectionResult
                = new ContentFilterCitedDetectionResult(filtered, detected, license);
            deserializedContentFilterCitedDetectionResult.url = url;
            return deserializedContentFilterCitedDetectionResult;
        });
    }
}
