// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.core.models.ResponseError;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Information about content filtering evaluated against input data to Azure OpenAI.
 */
@Immutable
public final class ContentFilterResultDetailsForPrompt
    implements JsonSerializable<ContentFilterResultDetailsForPrompt> {

    /*
     * Describes language related to anatomical organs and genitals, romantic relationships,
     * acts portrayed in erotic or affectionate terms, physical sexual acts, including
     * those portrayed as an assault or a forced sexual violent act against one’s will,
     * prostitution, pornography, and abuse.
     */
    @Generated
    private ContentFilterResult sexual;

    /*
     * Describes language related to physical actions intended to hurt, injure, damage, or
     * kill someone or something; describes weapons, etc.
     */
    @Generated
    private ContentFilterResult violence;

    /*
     * Describes language attacks or uses that include pejorative or discriminatory language
     * with reference to a person or identity group on the basis of certain differentiating
     * attributes of these groups including but not limited to race, ethnicity, nationality,
     * gender identity and expression, sexual orientation, religion, immigration status, ability
     * status, personal appearance, and body size.
     */
    @Generated
    private ContentFilterResult hate;

    /*
     * Describes language related to physical actions intended to purposely hurt, injure,
     * or damage one’s body, or kill oneself.
     */
    @Generated
    private ContentFilterResult selfHarm;

    /*
     * Describes whether profanity was detected.
     */
    @Generated
    private ContentFilterDetectionResult profanity;

    /*
     * Describes detection results against configured custom blocklists.
     */
    @Generated
    private ContentFilterDetailedResults customBlocklists;

    /*
     * Describes an error returned if the content filtering system is
     * down or otherwise unable to complete the operation in time.
     */
    @Generated
    private ResponseError error;

    /*
     * Whether a jailbreak attempt was detected in the prompt.
     */
    @Generated
    private ContentFilterDetectionResult jailbreak;

    /**
     * Get the sexual property: Describes language related to anatomical organs and genitals, romantic relationships,
     * acts portrayed in erotic or affectionate terms, physical sexual acts, including
     * those portrayed as an assault or a forced sexual violent act against one’s will,
     * prostitution, pornography, and abuse.
     *
     * @return the sexual value.
     */
    @Generated
    public ContentFilterResult getSexual() {
        return this.sexual;
    }

    /**
     * Get the violence property: Describes language related to physical actions intended to hurt, injure, damage, or
     * kill someone or something; describes weapons, etc.
     *
     * @return the violence value.
     */
    @Generated
    public ContentFilterResult getViolence() {
        return this.violence;
    }

    /**
     * Get the hate property: Describes language attacks or uses that include pejorative or discriminatory language
     * with reference to a person or identity group on the basis of certain differentiating
     * attributes of these groups including but not limited to race, ethnicity, nationality,
     * gender identity and expression, sexual orientation, religion, immigration status, ability
     * status, personal appearance, and body size.
     *
     * @return the hate value.
     */
    @Generated
    public ContentFilterResult getHate() {
        return this.hate;
    }

    /**
     * Get the selfHarm property: Describes language related to physical actions intended to purposely hurt, injure,
     * or damage one’s body, or kill oneself.
     *
     * @return the selfHarm value.
     */
    @Generated
    public ContentFilterResult getSelfHarm() {
        return this.selfHarm;
    }

    /**
     * Get the profanity property: Describes whether profanity was detected.
     *
     * @return the profanity value.
     */
    @Generated
    public ContentFilterDetectionResult getProfanity() {
        return this.profanity;
    }

    /**
     * Get the customBlocklists property: Describes detection results against configured custom blocklists.
     *
     * @return the customBlocklists value.
     */
    @Generated
    public ContentFilterDetailedResults getCustomBlocklists() {
        return this.customBlocklists;
    }

    /**
     * Get the error property: Describes an error returned if the content filtering system is
     * down or otherwise unable to complete the operation in time.
     *
     * @return the error value.
     */
    @Generated
    public ResponseError getError() {
        return this.error;
    }

    /**
     * Get the jailbreak property: Whether a jailbreak attempt was detected in the prompt.
     *
     * @return the jailbreak value.
     */
    @Generated
    public ContentFilterDetectionResult getJailbreak() {
        return this.jailbreak;
    }

    /**
     * Creates an instance of ContentFilterResultDetailsForPrompt class.
     */
    @Generated
    private ContentFilterResultDetailsForPrompt() {
    }

    /*
     * Whether an indirect attack was detected in the prompt.
     */
    @Generated
    private ContentFilterDetectionResult indirectAttack;

    /**
     * Get the indirectAttack property: Whether an indirect attack was detected in the prompt.
     *
     * @return the indirectAttack value.
     */
    @Generated
    public ContentFilterDetectionResult getIndirectAttack() {
        return this.indirectAttack;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("sexual", this.sexual);
        jsonWriter.writeJsonField("violence", this.violence);
        jsonWriter.writeJsonField("hate", this.hate);
        jsonWriter.writeJsonField("self_harm", this.selfHarm);
        jsonWriter.writeJsonField("profanity", this.profanity);
        jsonWriter.writeJsonField("custom_blocklists", this.customBlocklists);
        jsonWriter.writeJsonField("error", this.error);
        jsonWriter.writeJsonField("jailbreak", this.jailbreak);
        jsonWriter.writeJsonField("indirect_attack", this.indirectAttack);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ContentFilterResultDetailsForPrompt from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of ContentFilterResultDetailsForPrompt if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ContentFilterResultDetailsForPrompt.
     */
    @Generated
    public static ContentFilterResultDetailsForPrompt fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ContentFilterResultDetailsForPrompt deserializedContentFilterResultDetailsForPrompt
                = new ContentFilterResultDetailsForPrompt();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sexual".equals(fieldName)) {
                    deserializedContentFilterResultDetailsForPrompt.sexual = ContentFilterResult.fromJson(reader);
                } else if ("violence".equals(fieldName)) {
                    deserializedContentFilterResultDetailsForPrompt.violence = ContentFilterResult.fromJson(reader);
                } else if ("hate".equals(fieldName)) {
                    deserializedContentFilterResultDetailsForPrompt.hate = ContentFilterResult.fromJson(reader);
                } else if ("self_harm".equals(fieldName)) {
                    deserializedContentFilterResultDetailsForPrompt.selfHarm = ContentFilterResult.fromJson(reader);
                } else if ("profanity".equals(fieldName)) {
                    deserializedContentFilterResultDetailsForPrompt.profanity
                        = ContentFilterDetectionResult.fromJson(reader);
                } else if ("custom_blocklists".equals(fieldName)) {
                    deserializedContentFilterResultDetailsForPrompt.customBlocklists
                        = ContentFilterDetailedResults.fromJson(reader);
                } else if ("error".equals(fieldName)) {
                    deserializedContentFilterResultDetailsForPrompt.error = ResponseError.fromJson(reader);
                } else if ("jailbreak".equals(fieldName)) {
                    deserializedContentFilterResultDetailsForPrompt.jailbreak
                        = ContentFilterDetectionResult.fromJson(reader);
                } else if ("indirect_attack".equals(fieldName)) {
                    deserializedContentFilterResultDetailsForPrompt.indirectAttack
                        = ContentFilterDetectionResult.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedContentFilterResultDetailsForPrompt;
        });
    }
}
