// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The authentication options for Azure OpenAI On Your Data when using an API key.
 */
@Immutable
public final class OnYourDataApiKeyAuthenticationOptions extends OnYourDataAuthenticationOptions {

    /*
     * The API key to use for authentication.
     */
    @Generated
    private final String key;

    /**
     * Creates an instance of OnYourDataApiKeyAuthenticationOptions class.
     *
     * @param key the key value to set.
     */
    @Generated
    public OnYourDataApiKeyAuthenticationOptions(String key) {
        this.key = key;
    }

    /**
     * Get the key property: The API key to use for authentication.
     *
     * @return the key value.
     */
    @Generated
    public String getKey() {
        return this.key;
    }

    /*
     * The authentication type.
     */
    @Generated
    private OnYourDataAuthenticationType type = OnYourDataAuthenticationType.API_KEY;

    /**
     * Get the type property: The authentication type.
     *
     * @return the type value.
     */
    @Generated
    @Override
    public OnYourDataAuthenticationType getType() {
        return this.type;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("key", this.key);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of OnYourDataApiKeyAuthenticationOptions from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of OnYourDataApiKeyAuthenticationOptions if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the OnYourDataApiKeyAuthenticationOptions.
     */
    @Generated
    public static OnYourDataApiKeyAuthenticationOptions fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String key = null;
            OnYourDataAuthenticationType type = OnYourDataAuthenticationType.API_KEY;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("key".equals(fieldName)) {
                    key = reader.getString();
                } else if ("type".equals(fieldName)) {
                    type = OnYourDataAuthenticationType.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }
            OnYourDataApiKeyAuthenticationOptions deserializedOnYourDataApiKeyAuthenticationOptions
                = new OnYourDataApiKeyAuthenticationOptions(key);
            deserializedOnYourDataApiKeyAuthenticationOptions.type = type;
            return deserializedOnYourDataApiKeyAuthenticationOptions;
        });
    }
}
