// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The authentication options for Azure OpenAI On Your Data when using an Elasticsearch encoded API key.
 */
@Immutable
public final class OnYourDataEncodedApiKeyAuthenticationOptions extends OnYourDataAuthenticationOptions {

    /*
     * The encoded API key to use for authentication.
     */
    @Generated
    private final String encodedApiKey;

    /**
     * Creates an instance of OnYourDataEncodedApiKeyAuthenticationOptions class.
     *
     * @param encodedApiKey the encodedApiKey value to set.
     */
    @Generated
    public OnYourDataEncodedApiKeyAuthenticationOptions(String encodedApiKey) {
        this.encodedApiKey = encodedApiKey;
    }

    /**
     * Get the encodedApiKey property: The encoded API key to use for authentication.
     *
     * @return the encodedApiKey value.
     */
    @Generated
    public String getEncodedApiKey() {
        return this.encodedApiKey;
    }

    /*
     * The authentication type.
     */
    @Generated
    private OnYourDataAuthenticationType type = OnYourDataAuthenticationType.ENCODED_API_KEY;

    /**
     * Get the type property: The authentication type.
     *
     * @return the type value.
     */
    @Generated
    @Override
    public OnYourDataAuthenticationType getType() {
        return this.type;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("encoded_api_key", this.encodedApiKey);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of OnYourDataEncodedApiKeyAuthenticationOptions from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of OnYourDataEncodedApiKeyAuthenticationOptions if the JsonReader was pointing to an instance
     * of it, or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the OnYourDataEncodedApiKeyAuthenticationOptions.
     */
    @Generated
    public static OnYourDataEncodedApiKeyAuthenticationOptions fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String encodedApiKey = null;
            OnYourDataAuthenticationType type = OnYourDataAuthenticationType.ENCODED_API_KEY;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("encoded_api_key".equals(fieldName)) {
                    encodedApiKey = reader.getString();
                } else if ("type".equals(fieldName)) {
                    type = OnYourDataAuthenticationType.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }
            OnYourDataEncodedApiKeyAuthenticationOptions deserializedOnYourDataEncodedApiKeyAuthenticationOptions
                = new OnYourDataEncodedApiKeyAuthenticationOptions(encodedApiKey);
            deserializedOnYourDataEncodedApiKeyAuthenticationOptions.type = type;
            return deserializedOnYourDataEncodedApiKeyAuthenticationOptions;
        });
    }
}
