// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The authentication options for Azure OpenAI On Your Data when using a user-assigned managed identity.
 */
@Immutable
public final class OnYourDataUserAssignedManagedIdentityAuthenticationOptions extends OnYourDataAuthenticationOptions {

    /*
     * The resource ID of the user-assigned managed identity to use for authentication.
     */
    @Generated
    private final String managedIdentityResourceId;

    /**
     * Creates an instance of OnYourDataUserAssignedManagedIdentityAuthenticationOptions class.
     *
     * @param managedIdentityResourceId the managedIdentityResourceId value to set.
     */
    @Generated
    public OnYourDataUserAssignedManagedIdentityAuthenticationOptions(String managedIdentityResourceId) {
        this.managedIdentityResourceId = managedIdentityResourceId;
    }

    /**
     * Get the managedIdentityResourceId property: The resource ID of the user-assigned managed identity to use for
     * authentication.
     *
     * @return the managedIdentityResourceId value.
     */
    @Generated
    public String getManagedIdentityResourceId() {
        return this.managedIdentityResourceId;
    }

    /*
     * The authentication type.
     */
    @Generated
    private OnYourDataAuthenticationType type = OnYourDataAuthenticationType.USER_ASSIGNED_MANAGED_IDENTITY;

    /**
     * Get the type property: The authentication type.
     *
     * @return the type value.
     */
    @Generated
    @Override
    public OnYourDataAuthenticationType getType() {
        return this.type;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("managed_identity_resource_id", this.managedIdentityResourceId);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of OnYourDataUserAssignedManagedIdentityAuthenticationOptions from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of OnYourDataUserAssignedManagedIdentityAuthenticationOptions if the JsonReader was pointing
     * to an instance of it, or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the
     * OnYourDataUserAssignedManagedIdentityAuthenticationOptions.
     */
    @Generated
    public static OnYourDataUserAssignedManagedIdentityAuthenticationOptions fromJson(JsonReader jsonReader)
        throws IOException {
        return jsonReader.readObject(reader -> {
            String managedIdentityResourceId = null;
            OnYourDataAuthenticationType type = OnYourDataAuthenticationType.USER_ASSIGNED_MANAGED_IDENTITY;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("managed_identity_resource_id".equals(fieldName)) {
                    managedIdentityResourceId = reader.getString();
                } else if ("type".equals(fieldName)) {
                    type = OnYourDataAuthenticationType.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }
            OnYourDataUserAssignedManagedIdentityAuthenticationOptions deserializedOnYourDataUserAssignedManagedIdentityAuthenticationOptions
                = new OnYourDataUserAssignedManagedIdentityAuthenticationOptions(managedIdentityResourceId);
            deserializedOnYourDataUserAssignedManagedIdentityAuthenticationOptions.type = type;
            return deserializedOnYourDataUserAssignedManagedIdentityAuthenticationOptions;
        });
    }
}
