/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.models;

import com.azure.ai.openai.models.ChatRequestMessage;
import com.azure.ai.openai.models.ChatRole;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class ChatRequestFunctionMessage
extends ChatRequestMessage {
    private final String name;
    private final String content;
    private ChatRole role = ChatRole.FUNCTION;

    public ChatRequestFunctionMessage(String name, String content) {
        this.name = name;
        this.content = content;
    }

    public String getName() {
        return this.name;
    }

    public String getContent() {
        return this.content;
    }

    @Override
    public ChatRole getRole() {
        return this.role;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("content", this.content);
        jsonWriter.writeStringField("role", this.role == null ? null : this.role.toString());
        return jsonWriter.writeEndObject();
    }

    public static ChatRequestFunctionMessage fromJson(JsonReader jsonReader) throws IOException {
        return (ChatRequestFunctionMessage)jsonReader.readObject(reader -> {
            String name = null;
            String content = null;
            ChatRole role = ChatRole.FUNCTION;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    continue;
                }
                if ("content".equals(fieldName)) {
                    content = reader.getString();
                    continue;
                }
                if ("role".equals(fieldName)) {
                    role = ChatRole.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            ChatRequestFunctionMessage deserializedChatRequestFunctionMessage = new ChatRequestFunctionMessage(name, content);
            deserializedChatRequestFunctionMessage.role = role;
            return deserializedChatRequestFunctionMessage;
        });
    }
}

