/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class ContentFilterCitedDetectionResult
implements JsonSerializable<ContentFilterCitedDetectionResult> {
    private final boolean filtered;
    private final boolean detected;
    private String url;
    private final String license;

    private ContentFilterCitedDetectionResult(boolean filtered, boolean detected, String license) {
        this.filtered = filtered;
        this.detected = detected;
        this.license = license;
    }

    public boolean isFiltered() {
        return this.filtered;
    }

    public boolean isDetected() {
        return this.detected;
    }

    public String getUrl() {
        return this.url;
    }

    public String getLicense() {
        return this.license;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("filtered", this.filtered);
        jsonWriter.writeBooleanField("detected", this.detected);
        jsonWriter.writeStringField("license", this.license);
        jsonWriter.writeStringField("URL", this.url);
        return jsonWriter.writeEndObject();
    }

    public static ContentFilterCitedDetectionResult fromJson(JsonReader jsonReader) throws IOException {
        return (ContentFilterCitedDetectionResult)jsonReader.readObject(reader -> {
            boolean filtered = false;
            boolean detected = false;
            String license = null;
            String url = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("filtered".equals(fieldName)) {
                    filtered = reader.getBoolean();
                    continue;
                }
                if ("detected".equals(fieldName)) {
                    detected = reader.getBoolean();
                    continue;
                }
                if ("license".equals(fieldName)) {
                    license = reader.getString();
                    continue;
                }
                if ("URL".equals(fieldName)) {
                    url = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            ContentFilterCitedDetectionResult deserializedContentFilterCitedDetectionResult = new ContentFilterCitedDetectionResult(filtered, detected, license);
            deserializedContentFilterCitedDetectionResult.url = url;
            return deserializedContentFilterCitedDetectionResult;
        });
    }
}

