/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.models;

import com.azure.ai.openai.models.ElasticsearchIndexFieldMappingOptions;
import com.azure.ai.openai.models.ElasticsearchQueryType;
import com.azure.ai.openai.models.OnYourDataAuthenticationOptions;
import com.azure.ai.openai.models.OnYourDataContextProperty;
import com.azure.ai.openai.models.OnYourDataVectorizationSource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class ElasticsearchChatExtensionParameters
implements JsonSerializable<ElasticsearchChatExtensionParameters> {
    private OnYourDataAuthenticationOptions authentication;
    private Integer topNDocuments;
    private Boolean inScope;
    private Integer strictness;
    private String roleInformation;
    private final String endpoint;
    private final String indexName;
    private ElasticsearchIndexFieldMappingOptions fieldsMapping;
    private ElasticsearchQueryType queryType;
    private OnYourDataVectorizationSource embeddingDependency;
    private Integer maxSearchQueries;
    private Boolean allowPartialResult;
    private List<OnYourDataContextProperty> includeContexts;

    public ElasticsearchChatExtensionParameters(String endpoint, String indexName) {
        this.endpoint = endpoint;
        this.indexName = indexName;
    }

    public OnYourDataAuthenticationOptions getAuthentication() {
        return this.authentication;
    }

    public ElasticsearchChatExtensionParameters setAuthentication(OnYourDataAuthenticationOptions authentication) {
        this.authentication = authentication;
        return this;
    }

    public Integer getTopNDocuments() {
        return this.topNDocuments;
    }

    public ElasticsearchChatExtensionParameters setTopNDocuments(Integer topNDocuments) {
        this.topNDocuments = topNDocuments;
        return this;
    }

    public Boolean isInScope() {
        return this.inScope;
    }

    public ElasticsearchChatExtensionParameters setInScope(Boolean inScope) {
        this.inScope = inScope;
        return this;
    }

    public Integer getStrictness() {
        return this.strictness;
    }

    public ElasticsearchChatExtensionParameters setStrictness(Integer strictness) {
        this.strictness = strictness;
        return this;
    }

    public String getRoleInformation() {
        return this.roleInformation;
    }

    public ElasticsearchChatExtensionParameters setRoleInformation(String roleInformation) {
        this.roleInformation = roleInformation;
        return this;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public ElasticsearchIndexFieldMappingOptions getFieldsMapping() {
        return this.fieldsMapping;
    }

    public ElasticsearchChatExtensionParameters setFieldsMapping(ElasticsearchIndexFieldMappingOptions fieldsMapping) {
        this.fieldsMapping = fieldsMapping;
        return this;
    }

    public ElasticsearchQueryType getQueryType() {
        return this.queryType;
    }

    public ElasticsearchChatExtensionParameters setQueryType(ElasticsearchQueryType queryType) {
        this.queryType = queryType;
        return this;
    }

    public OnYourDataVectorizationSource getEmbeddingDependency() {
        return this.embeddingDependency;
    }

    public ElasticsearchChatExtensionParameters setEmbeddingDependency(OnYourDataVectorizationSource embeddingDependency) {
        this.embeddingDependency = embeddingDependency;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("endpoint", this.endpoint);
        jsonWriter.writeStringField("index_name", this.indexName);
        jsonWriter.writeJsonField("authentication", (JsonSerializable)this.authentication);
        jsonWriter.writeNumberField("top_n_documents", (Number)this.topNDocuments);
        jsonWriter.writeBooleanField("in_scope", this.inScope);
        jsonWriter.writeNumberField("strictness", (Number)this.strictness);
        jsonWriter.writeStringField("role_information", this.roleInformation);
        jsonWriter.writeNumberField("max_search_queries", (Number)this.maxSearchQueries);
        jsonWriter.writeBooleanField("allow_partial_result", this.allowPartialResult);
        jsonWriter.writeArrayField("include_contexts", this.includeContexts, (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeJsonField("fields_mapping", (JsonSerializable)this.fieldsMapping);
        jsonWriter.writeStringField("query_type", this.queryType == null ? null : this.queryType.toString());
        jsonWriter.writeJsonField("embedding_dependency", (JsonSerializable)this.embeddingDependency);
        return jsonWriter.writeEndObject();
    }

    public static ElasticsearchChatExtensionParameters fromJson(JsonReader jsonReader) throws IOException {
        return (ElasticsearchChatExtensionParameters)jsonReader.readObject(reader -> {
            String endpoint = null;
            String indexName = null;
            OnYourDataAuthenticationOptions authentication = null;
            Integer topNDocuments = null;
            Boolean inScope = null;
            Integer strictness = null;
            String roleInformation = null;
            Integer maxSearchQueries = null;
            Boolean allowPartialResult = null;
            List includeContexts = null;
            ElasticsearchIndexFieldMappingOptions fieldsMapping = null;
            ElasticsearchQueryType queryType = null;
            OnYourDataVectorizationSource embeddingDependency = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("endpoint".equals(fieldName)) {
                    endpoint = reader.getString();
                    continue;
                }
                if ("index_name".equals(fieldName)) {
                    indexName = reader.getString();
                    continue;
                }
                if ("authentication".equals(fieldName)) {
                    authentication = OnYourDataAuthenticationOptions.fromJson(reader);
                    continue;
                }
                if ("top_n_documents".equals(fieldName)) {
                    topNDocuments = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("in_scope".equals(fieldName)) {
                    inScope = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("strictness".equals(fieldName)) {
                    strictness = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("role_information".equals(fieldName)) {
                    roleInformation = reader.getString();
                    continue;
                }
                if ("max_search_queries".equals(fieldName)) {
                    maxSearchQueries = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("allow_partial_result".equals(fieldName)) {
                    allowPartialResult = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("include_contexts".equals(fieldName)) {
                    includeContexts = reader.readArray(reader1 -> OnYourDataContextProperty.fromString(reader1.getString()));
                    continue;
                }
                if ("fields_mapping".equals(fieldName)) {
                    fieldsMapping = ElasticsearchIndexFieldMappingOptions.fromJson(reader);
                    continue;
                }
                if ("query_type".equals(fieldName)) {
                    queryType = ElasticsearchQueryType.fromString(reader.getString());
                    continue;
                }
                if ("embedding_dependency".equals(fieldName)) {
                    embeddingDependency = OnYourDataVectorizationSource.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            ElasticsearchChatExtensionParameters deserializedElasticsearchChatExtensionParameters = new ElasticsearchChatExtensionParameters(endpoint, indexName);
            deserializedElasticsearchChatExtensionParameters.authentication = authentication;
            deserializedElasticsearchChatExtensionParameters.topNDocuments = topNDocuments;
            deserializedElasticsearchChatExtensionParameters.inScope = inScope;
            deserializedElasticsearchChatExtensionParameters.strictness = strictness;
            deserializedElasticsearchChatExtensionParameters.roleInformation = roleInformation;
            deserializedElasticsearchChatExtensionParameters.maxSearchQueries = maxSearchQueries;
            deserializedElasticsearchChatExtensionParameters.allowPartialResult = allowPartialResult;
            deserializedElasticsearchChatExtensionParameters.includeContexts = includeContexts;
            deserializedElasticsearchChatExtensionParameters.fieldsMapping = fieldsMapping;
            deserializedElasticsearchChatExtensionParameters.queryType = queryType;
            deserializedElasticsearchChatExtensionParameters.embeddingDependency = embeddingDependency;
            return deserializedElasticsearchChatExtensionParameters;
        });
    }

    public Integer getMaxSearchQueries() {
        return this.maxSearchQueries;
    }

    public ElasticsearchChatExtensionParameters setMaxSearchQueries(Integer maxSearchQueries) {
        this.maxSearchQueries = maxSearchQueries;
        return this;
    }

    public Boolean isAllowPartialResult() {
        return this.allowPartialResult;
    }

    public ElasticsearchChatExtensionParameters setAllowPartialResult(Boolean allowPartialResult) {
        this.allowPartialResult = allowPartialResult;
        return this;
    }

    public List<OnYourDataContextProperty> getIncludeContexts() {
        return this.includeContexts;
    }

    public ElasticsearchChatExtensionParameters setIncludeContexts(List<OnYourDataContextProperty> includeContexts) {
        this.includeContexts = includeContexts;
        return this;
    }
}

