/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.implementation;

import com.azure.core.util.Base64Util;
import com.azure.core.util.BinaryData;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

public final class EmbeddingsUtils {
    private static final ObjectMapper JSON_MAPPER = new ObjectMapper();

    public static BinaryData addEncodingFormat(BinaryData inputJson) throws JsonProcessingException {
        JsonNode jsonNode = JSON_MAPPER.readTree(inputJson.toString());
        if (jsonNode instanceof ObjectNode) {
            ObjectNode objectNode = (ObjectNode)jsonNode;
            if (objectNode.has("encoding_format")) {
                return inputJson;
            }
            objectNode.put("encoding_format", "base64");
            inputJson = BinaryData.fromBytes((byte[])objectNode.toString().getBytes(StandardCharsets.UTF_8));
        }
        return inputJson;
    }

    public static List<Float> convertBase64ToFloatList(String embedding) {
        byte[] bytes = Base64Util.decodeString((String)embedding);
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        FloatBuffer floatBuffer = byteBuffer.asFloatBuffer();
        ArrayList<Float> floatList = new ArrayList<Float>(floatBuffer.remaining());
        while (floatBuffer.hasRemaining()) {
            floatList.add(Float.valueOf(floatBuffer.get()));
        }
        return floatList;
    }
}

