/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.models;

import com.azure.ai.openai.implementation.EmbeddingsUtils;
import com.azure.core.util.BinaryData;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class EmbeddingItem {
    @JsonProperty(value="embedding")
    private BinaryData embedding;
    private final String embeddingBase64;
    @JsonProperty(value="index")
    private int promptIndex;

    public List<Float> getEmbedding() {
        return EmbeddingsUtils.convertBase64ToFloatList(this.embeddingBase64);
    }

    public String getEmbeddingAsString() {
        return this.embeddingBase64;
    }

    public int getPromptIndex() {
        return this.promptIndex;
    }

    @JsonCreator
    private EmbeddingItem(@JsonProperty(value="embedding") BinaryData embedding, @JsonProperty(value="index") int promptIndex) {
        this.embedding = embedding;
        this.promptIndex = promptIndex;
        this.embeddingBase64 = embedding.toString();
    }
}

