/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.models;

import com.azure.ai.openai.models.ImageGenerationData;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.List;

public final class ImageGenerations {
    @JsonProperty(value="created")
    private long createdAt;
    @JsonProperty(value="data")
    private List<ImageGenerationData> data;

    private ImageGenerations(OffsetDateTime createdAt, List<ImageGenerationData> data) {
        this.createdAt = createdAt.toEpochSecond();
        this.data = data;
    }

    @JsonCreator
    private ImageGenerations(@JsonProperty(value="created") long createdAt, @JsonProperty(value="data") List<ImageGenerationData> data) {
        this(OffsetDateTime.ofInstant(Instant.ofEpochSecond(createdAt), ZoneOffset.UTC), data);
    }

    public OffsetDateTime getCreatedAt() {
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.createdAt), ZoneOffset.UTC);
    }

    public List<ImageGenerationData> getData() {
        return this.data;
    }
}

