/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.common.implementation;

import com.azure.core.credential.AccessToken;
import java.nio.charset.Charset;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.util.Base64;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TokenParser {
    private static final String EXP_CLAIM_REGEX = "\"exp\":*([0-9]+)";

    public AccessToken parseJWTToken(String rawToken) {
        Objects.requireNonNull(rawToken, "'rawToken' cannot be null.");
        String jwt = new String(Base64.getDecoder().decode(rawToken.split("\\.")[1]), Charset.forName("UTF-8"));
        Pattern pattern = Pattern.compile(EXP_CLAIM_REGEX);
        Matcher matcher = pattern.matcher(jwt);
        matcher.find();
        long expire = Long.parseLong(matcher.group(1));
        Instant expiresAt = Instant.ofEpochSecond(expire);
        OffsetDateTime offsetExpiry = expiresAt.atOffset(OffsetDateTime.now().getOffset());
        return new AccessToken(rawToken, offsetExpiry);
    }
}

