/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.amqp.models;

import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Objects;

public class AmqpMessageProperties {
    private OffsetDateTime absoluteExpiryTime;
    private String contentEncoding;
    private String contentType;
    private String correlationId;
    private OffsetDateTime creationTime;
    private String groupId;
    private Long groupSequence;
    private String messageId;
    private String replyToGroupId;
    private String replyTo;
    private String to;
    private String subject;
    private byte[] userId;

    AmqpMessageProperties() {
    }

    AmqpMessageProperties(AmqpMessageProperties properties) {
        Objects.requireNonNull(properties, "'properties' cannot be null.");
        this.absoluteExpiryTime = properties.getAbsoluteExpiryTime();
        this.contentEncoding = properties.getContentEncoding();
        this.contentType = properties.getContentType();
        this.correlationId = properties.getCorrelationId();
        this.creationTime = properties.getCreationTime();
        this.groupId = properties.getGroupId();
        this.groupSequence = properties.getGroupSequence();
        this.messageId = properties.getMessageId();
        this.replyToGroupId = properties.getReplyToGroupId();
        this.replyTo = properties.getReplyTo();
        this.to = properties.getTo();
        this.subject = properties.getSubject();
        this.userId = properties.getUserId();
    }

    public OffsetDateTime getAbsoluteExpiryTime() {
        return this.absoluteExpiryTime;
    }

    public AmqpMessageProperties setAbsoluteExpiryTime(OffsetDateTime absoluteExpiryTime) {
        this.absoluteExpiryTime = absoluteExpiryTime;
        return this;
    }

    public String getContentEncoding() {
        return this.contentEncoding;
    }

    public AmqpMessageProperties setContentEncoding(String contentEncoding) {
        this.contentEncoding = contentEncoding;
        return this;
    }

    public String getContentType() {
        return this.contentType;
    }

    public AmqpMessageProperties setContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    public AmqpMessageProperties setCorrelationId(String correlationId) {
        this.correlationId = correlationId;
        return this;
    }

    public OffsetDateTime getCreationTime() {
        return this.creationTime;
    }

    public AmqpMessageProperties setCreationTime(OffsetDateTime creationTime) {
        this.creationTime = creationTime;
        return this;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public AmqpMessageProperties setGroupId(String groupId) {
        this.groupId = groupId;
        return this;
    }

    public Long getGroupSequence() {
        return this.groupSequence;
    }

    public AmqpMessageProperties setGroupSequence(Long groupSequence) {
        this.groupSequence = groupSequence;
        return this;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public AmqpMessageProperties setMessageId(String messageId) {
        this.messageId = messageId;
        return this;
    }

    public String getReplyTo() {
        return this.replyTo;
    }

    public AmqpMessageProperties setReplyTo(String replyTo) {
        this.replyTo = replyTo;
        return this;
    }

    public String getReplyToGroupId() {
        return this.replyToGroupId;
    }

    public AmqpMessageProperties setReplyToGroupId(String replyToGroupId) {
        this.replyToGroupId = replyToGroupId;
        return this;
    }

    public String getSubject() {
        return this.subject;
    }

    public AmqpMessageProperties setSubject(String subject) {
        this.subject = subject;
        return this;
    }

    public String getTo() {
        return this.to;
    }

    public AmqpMessageProperties setTo(String to) {
        this.to = to;
        return this;
    }

    public byte[] getUserId() {
        return this.userId != null ? Arrays.copyOf(this.userId, this.userId.length) : new byte[]{};
    }

    public AmqpMessageProperties setUserId(byte[] userId) {
        this.userId = userId != null ? Arrays.copyOf(userId, userId.length) : new byte[]{};
        return this;
    }
}

