/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.amqp;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public enum AmqpMessageConstant {
    MESSAGE_ID("message-id"),
    USER_ID("user-id"),
    TO("to"),
    SUBJECT("subject"),
    REPLY_TO("reply-to"),
    CORRELATION_ID("correlation-id"),
    CONTENT_TYPE("content-type"),
    CONTENT_ENCODING("content-encoding"),
    ABSOLUTE_EXPIRY_TIME("absolute-expiry-time"),
    CREATION_TIME("creation-time"),
    GROUP_ID("group-id"),
    GROUP_SEQUENCE("group-sequence"),
    REPLY_TO_GROUP_ID("reply-to-group-id"),
    OFFSET_ANNOTATION_NAME("x-opt-offset"),
    ENQUEUED_TIME_UTC_ANNOTATION_NAME("x-opt-enqueued-time"),
    PARTITION_KEY_ANNOTATION_NAME("x-opt-partition-key"),
    SEQUENCE_NUMBER_ANNOTATION_NAME("x-opt-sequence-number"),
    PUBLISHER_ANNOTATION_NAME("x-opt-publisher"),
    SCHEDULED_ENQUEUE_UTC_TIME_NAME("x-opt-scheduled-enqueue-time"),
    VIA_PARTITION_KEY_ANNOTATION_NAME("x-opt-via-partition-key"),
    LOCKED_UNTIL_KEY_ANNOTATION_NAME("x-opt-locked-until"),
    DEAD_LETTER_SOURCE_KEY_ANNOTATION_NAME("x-opt-deadletter-source"),
    ENQUEUED_SEQUENCE_NUMBER_ANNOTATION_NAME("x-opt-enqueue-sequence-number"),
    DEAD_LETTER_DESCRIPTION_ANNOTATION_NAME("DeadLetterErrorDescription"),
    DEAD_LETTER_REASON_ANNOTATION_NAME("DeadLetterReason");

    private static final Map<String, AmqpMessageConstant> RESERVED_CONSTANTS_MAP;
    private final String constant;

    private AmqpMessageConstant(String value) {
        this.constant = value;
    }

    public String getValue() {
        return this.constant;
    }

    public static AmqpMessageConstant fromString(String value) {
        Objects.requireNonNull(value, "'value' cannot be null.");
        return RESERVED_CONSTANTS_MAP.get(value);
    }

    static {
        RESERVED_CONSTANTS_MAP = new HashMap<String, AmqpMessageConstant>();
        for (AmqpMessageConstant error : AmqpMessageConstant.values()) {
            RESERVED_CONSTANTS_MAP.put(error.getValue(), error);
        }
    }
}

