/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.amqp.implementation.handler;

import com.azure.core.amqp.implementation.AmqpLoggingUtils;
import com.azure.core.amqp.implementation.AmqpMetricsProvider;
import com.azure.core.amqp.implementation.handler.LinkHandler;
import com.azure.core.util.logging.LoggingEventBuilder;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.messaging.Modified;
import org.apache.qpid.proton.amqp.transport.DeliveryState;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import org.apache.qpid.proton.engine.Delivery;
import org.apache.qpid.proton.engine.EndpointState;
import org.apache.qpid.proton.engine.Event;
import org.apache.qpid.proton.engine.Link;
import org.apache.qpid.proton.engine.Receiver;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Sinks;

public class ReceiveLinkHandler
extends LinkHandler {
    private final String linkName;
    private final AtomicBoolean isRemoteActive = new AtomicBoolean();
    private final AtomicBoolean isTerminated = new AtomicBoolean();
    private final Sinks.Many<Delivery> deliveries = Sinks.many().multicast().onBackpressureBuffer();
    private final Set<Delivery> queuedDeliveries = Collections.newSetFromMap(new ConcurrentHashMap());
    private final String entityPath;

    public ReceiveLinkHandler(String connectionId, String hostname, String linkName, String entityPath, AmqpMetricsProvider metricsProvider) {
        super(connectionId, hostname, entityPath, metricsProvider);
        this.linkName = Objects.requireNonNull(linkName, "'linkName' cannot be null.");
        this.entityPath = Objects.requireNonNull(entityPath, "'entityPath' cannot be null.");
    }

    public String getLinkName() {
        return this.linkName;
    }

    public Flux<Delivery> getDeliveredMessages() {
        return this.deliveries.asFlux().doOnNext(this.queuedDeliveries::remove);
    }

    @Override
    public void close() {
        if (this.isTerminated.getAndSet(true)) {
            return;
        }
        this.clearAndCompleteDeliveries("Could not emit deliveries.close when closing handler.");
        this.onNext(EndpointState.CLOSED);
    }

    public void onLinkLocalOpen(Event event) {
        Link link = event.getLink();
        if (link instanceof Receiver) {
            this.logger.atVerbose().addKeyValue("entityPath", this.entityPath).addKeyValue("linkName", link.getName()).addKeyValue("localSource", (Object)link.getSource()).log("onLinkLocalOpen");
        }
    }

    public void onLinkRemoteOpen(Event event) {
        Link link = event.getLink();
        if (!(link instanceof Receiver)) {
            return;
        }
        LoggingEventBuilder logBuilder = this.logger.atInfo().addKeyValue("entityPath", this.entityPath).addKeyValue("linkName", link.getName());
        if (link.getRemoteSource() != null) {
            logBuilder.addKeyValue("remoteSource", (Object)link.getRemoteSource());
            if (!this.isRemoteActive.getAndSet(true)) {
                this.onNext(EndpointState.ACTIVE);
            }
        } else {
            logBuilder.addKeyValue("action", "waitingForError");
        }
        logBuilder.log("onLinkRemoteOpen");
    }

    public void onDelivery(Event event) {
        if (!this.isRemoteActive.getAndSet(true)) {
            this.onNext(EndpointState.ACTIVE);
        }
        Delivery delivery = event.getDelivery();
        Receiver link = (Receiver)delivery.getLink();
        boolean wasSettled = delivery.isSettled();
        if (!delivery.isPartial()) {
            if (wasSettled) {
                if (link != null) {
                    AmqpLoggingUtils.addErrorCondition(this.logger.atInfo(), link.getRemoteCondition()).addKeyValue("entityPath", this.entityPath).addKeyValue("linkName", this.linkName).addKeyValue("updatedLinkCredit", (long)link.getCredit()).addKeyValue("remoteCredit", (long)link.getRemoteCredit()).addKeyValue("delivery.isSettled", delivery.isSettled()).log("onDelivery. Was already settled.");
                } else {
                    this.logger.atWarning().addKeyValue("entityPath", this.entityPath).addKeyValue("delivery.isSettled", delivery.isSettled()).log("Settled delivery with no link.");
                }
            } else if (link.getLocalState() == EndpointState.CLOSED) {
                delivery.disposition((DeliveryState)new Modified());
                delivery.settle();
            } else {
                this.queuedDeliveries.add(delivery);
                this.deliveries.emitNext((Object)delivery, (signalType, emitResult) -> {
                    this.logger.atWarning().addKeyValue("entityPath", this.entityPath).addKeyValue("linkName", this.linkName).addKeyValue("emitResult", (Object)emitResult).log("Could not emit delivery. {}", new Object[]{delivery});
                    if (emitResult == Sinks.EmitResult.FAIL_OVERFLOW && link.getLocalState() != EndpointState.CLOSED) {
                        link.setCondition(new ErrorCondition(Symbol.getSymbol((String)"delivery-buffer-overflow"), "Deliveries are not processed fast enough. Closing local link."));
                        link.close();
                        return true;
                    }
                    return false;
                });
            }
        }
        if (link != null) {
            ErrorCondition condition = link.getRemoteCondition();
            AmqpLoggingUtils.addErrorCondition(this.logger.atVerbose(), condition).addKeyValue("entityPath", this.entityPath).addKeyValue("linkName", this.linkName).addKeyValue("updatedLinkCredit", (long)link.getCredit()).addKeyValue("remoteCredit", (long)link.getRemoteCredit()).addKeyValue("delivery.isPartial", delivery.isPartial()).addKeyValue("delivery.isSettled", wasSettled).log("onDelivery.");
        }
    }

    @Override
    public void onLinkLocalClose(Event event) {
        super.onLinkLocalClose(event);
        if (!this.isRemoteActive.get()) {
            this.logger.atInfo().addKeyValue("entityPath", this.entityPath).addKeyValue("linkName", this.linkName).log("Receiver link was never active. Closing endpoint states");
            super.close();
        }
    }

    @Override
    public void onLinkRemoteClose(Event event) {
        this.clearAndCompleteDeliveries("Could not complete 'deliveries' when remotely closed.");
        super.onLinkRemoteClose(event);
    }

    @Override
    public void onLinkFinal(Event event) {
        this.close();
        super.onLinkFinal(event);
    }

    private void clearAndCompleteDeliveries(String errorMessage) {
        this.deliveries.emitComplete((signalType, emitResult) -> {
            this.logger.atVerbose().addKeyValue("entityPath", this.entityPath).addKeyValue("linkName", this.linkName).log(errorMessage);
            return false;
        });
        this.queuedDeliveries.forEach(delivery -> {
            delivery.disposition((DeliveryState)new Modified());
            delivery.settle();
        });
        this.queuedDeliveries.clear();
    }
}

