/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.management.implementation.polling;

import com.azure.core.http.HttpHeaders;
import com.azure.core.management.implementation.polling.Error;
import com.azure.core.management.implementation.polling.FinalResult;
import com.azure.core.management.implementation.polling.Util;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import java.net.URL;
import java.util.Objects;

final class LocationData
implements JsonSerializable<LocationData> {
    @JsonIgnore
    private static final ClientLogger LOGGER = new ClientLogger(LocationData.class);
    @JsonProperty(value="pollUrl", required=true)
    private URL pollUrl;
    @JsonProperty(value="provisioningState", required=true)
    private String provisioningState;
    @JsonProperty(value="pollError")
    private Error pollError;
    @JsonProperty(value="finalResult")
    private FinalResult finalResult;

    LocationData() {
    }

    LocationData(URL pollUrl) {
        this.pollUrl = Objects.requireNonNull(pollUrl, "'pollUrl' cannot be null.");
        this.provisioningState = "InProgress";
    }

    String getProvisioningState() {
        return this.provisioningState;
    }

    URL getPollUrl() {
        return this.pollUrl;
    }

    Error getPollError() {
        return this.pollError;
    }

    FinalResult getFinalResult() {
        return this.finalResult;
    }

    void update(int pollResponseStatusCode, HttpHeaders pollResponseHeaders, String pollResponseBody) {
        if (pollResponseStatusCode == 202) {
            try {
                this.provisioningState = "InProgress";
                URL locationUrl = Util.getLocationUrl(pollResponseHeaders, LOGGER);
                if (locationUrl != null) {
                    this.pollUrl = locationUrl;
                }
            }
            catch (Util.MalformedUrlException mue) {
                this.provisioningState = "Failed";
                this.pollError = new Error("Long running operation contains a malformed Location header.", pollResponseStatusCode, pollResponseHeaders.toMap(), pollResponseBody);
            }
        } else if (pollResponseStatusCode == 200 || pollResponseStatusCode == 201 || pollResponseStatusCode == 204) {
            this.provisioningState = "Succeeded";
            if (pollResponseBody != null) {
                this.finalResult = new FinalResult(null, pollResponseBody);
            }
        } else {
            this.provisioningState = "Failed";
            this.pollError = new Error("Polling failed with status code:" + pollResponseStatusCode, pollResponseStatusCode, pollResponseHeaders.toMap(), pollResponseBody);
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        return jsonWriter.writeStartObject().writeStringField("pollUrl", Objects.toString(this.pollUrl, null)).writeStringField("provisioningState", this.provisioningState).writeJsonField("pollError", (JsonSerializable)this.pollError).writeJsonField("finalResult", (JsonSerializable)this.finalResult).writeEndObject();
    }

    public static LocationData fromJson(JsonReader jsonReader) throws IOException {
        return (LocationData)jsonReader.readObject(reader -> {
            LocationData locationData = new LocationData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("pollUrl".equals(fieldName)) {
                    locationData.pollUrl = (URL)reader.getNullable(nonNullReader -> new URL(nonNullReader.getString()));
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    locationData.provisioningState = reader.getString();
                    continue;
                }
                if ("pollError".equals(fieldName)) {
                    locationData.pollError = Error.fromJson(reader);
                    continue;
                }
                if ("finalResult".equals(fieldName)) {
                    locationData.finalResult = FinalResult.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return locationData;
        });
    }
}

