/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.test.utils;

import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class MessageDigestUtils {
    private MessageDigestUtils() {
    }

    public static String md5(byte[] bytes) {
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            digest.update(bytes);
            return Base64.getEncoder().encodeToString(digest.digest());
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static Mono<String> md5(Flux<ByteBuffer> bufferFlux) {
        return bufferFlux.reduceWith(() -> {
            try {
                return MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e) {
                throw Exceptions.propagate((Throwable)e);
            }
        }, (digest, buffer) -> {
            digest.update((ByteBuffer)buffer);
            return digest;
        }).map(digest -> Base64.getEncoder().encodeToString(digest.digest()));
    }
}

