/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.test.utils;

import com.azure.core.http.HttpMethod;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.test.utils.HttpURLConnectionHttpClient;
import com.azure.core.test.utils.TestProxyDownloader;
import com.azure.core.test.utils.TestProxyUtils;
import com.azure.core.test.utils.TestUtils;
import com.azure.core.util.Configuration;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.Map;

public class TestProxyManager {
    private static final ClientLogger LOGGER = new ClientLogger(TestProxyManager.class);
    private Process proxy;
    private final Path testClassPath;

    public TestProxyManager(Path testClassPath) {
        this.testClassPath = testClassPath;
        Runtime.getRuntime().addShutdownHook(new Thread(this::stopProxy));
        if (this.runningLocally()) {
            TestProxyDownloader.installTestProxy(testClassPath);
        }
    }

    public void startProxy() {
        try {
            int read;
            if (this.runningLocally() && !TestProxyManager.checkAlive(1, Duration.ofSeconds(1L), null)) {
                String commandLine = Paths.get(TestProxyDownloader.getProxyDirectory().toString(), TestProxyUtils.getProxyProcessName()).toString();
                Path repoRoot = TestUtils.getRepoRootResolveUntil(this.testClassPath, "eng");
                Path repoRootTarget = repoRoot.resolve("target");
                if (!Files.exists(repoRootTarget, new LinkOption[0])) {
                    Files.createDirectory(repoRootTarget, new FileAttribute[0]);
                }
                ProcessBuilder builder = new ProcessBuilder(commandLine, "--storage-location", repoRoot.toString()).redirectOutput(repoRootTarget.resolve("test-proxy.log").toFile());
                Map<String, String> environment = builder.environment();
                environment.put("LOGGING__LOGLEVEL", "Debug");
                environment.put("LOGGING__LOGLEVEL__MICROSOFT", "Debug");
                environment.put("LOGGING__LOGLEVEL__DEFAULT", "Debug");
                this.proxy = builder.start();
            }
            if (TestProxyManager.checkAlive(10, Duration.ofSeconds(6L), this.proxy)) {
                return;
            }
            ByteArrayOutputStream errorLog = new ByteArrayOutputStream();
            byte[] buffer = new byte[4096];
            while ((read = this.proxy.getErrorStream().read(buffer)) != -1) {
                errorLog.write(buffer, 0, read);
            }
            String errorLogString = new String(errorLog.toByteArray(), StandardCharsets.UTF_8);
            if (CoreUtils.isNullOrEmpty((CharSequence)errorLogString)) {
                throw new RuntimeException("Test proxy did not initialize.");
            }
            throw new RuntimeException("Test proxy did not initialize. Error log: " + errorLogString);
        }
        catch (IOException e) {
            throw LOGGER.logExceptionAsError((RuntimeException)new UncheckedIOException(e));
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean checkAlive(int loops, Duration waitTime, Process proxy) throws InterruptedException {
        HttpURLConnectionHttpClient client = new HttpURLConnectionHttpClient();
        HttpRequest request = new HttpRequest(HttpMethod.GET, String.format("%s/admin/isalive", TestProxyUtils.getProxyUrl()));
        for (int i = 0; i < loops; ++i) {
            if (proxy != null && !proxy.isAlive() && proxy.exitValue() != 0) {
                return false;
            }
            try {
                HttpResponse response = client.sendSync(request, Context.NONE);
                if (response != null && response.getStatusCode() == 200) {
                    return true;
                }
                TestProxyUtils.checkForTestProxyErrors(response);
            }
            catch (Exception exception) {
                // empty catch block
            }
            Thread.sleep(waitTime.toMillis());
        }
        return false;
    }

    public void stopProxy() {
        if (this.proxy != null && this.proxy.isAlive()) {
            this.proxy.destroy();
        }
    }

    private boolean runningLocally() {
        return Configuration.getGlobalConfiguration().get("TF_BUILD") == null && Configuration.getGlobalConfiguration().get("CI") == null;
    }
}

