/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util.serializer;

import com.azure.core.annotation.HeaderCollection;
import com.azure.core.http.HttpHeader;
import com.azure.core.http.HttpHeaders;
import com.azure.core.implementation.ReflectionUtils;
import com.azure.core.implementation.TypeUtil;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.AdditionalPropertiesDeserializer;
import com.azure.core.util.serializer.AdditionalPropertiesSerializer;
import com.azure.core.util.serializer.Base64UrlSerializer;
import com.azure.core.util.serializer.ByteArraySerializer;
import com.azure.core.util.serializer.CollectionFormat;
import com.azure.core.util.serializer.DateTimeDeserializer;
import com.azure.core.util.serializer.DateTimeRfc1123Serializer;
import com.azure.core.util.serializer.DateTimeSerializer;
import com.azure.core.util.serializer.DurationSerializer;
import com.azure.core.util.serializer.FlatteningDeserializer;
import com.azure.core.util.serializer.FlatteningSerializer;
import com.azure.core.util.serializer.GeoJsonDeserializer;
import com.azure.core.util.serializer.GeoJsonSerializer;
import com.azure.core.util.serializer.HttpHeadersSerializer;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.core.util.serializer.SerializerEncoding;
import com.azure.core.util.serializer.UnixTimeDeserializer;
import com.azure.core.util.serializer.UnixTimeSerializer;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.cfg.MapperBuilder;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.dataformat.xml.deser.FromXmlParser;
import com.fasterxml.jackson.dataformat.xml.ser.ToXmlGenerator;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.regex.Pattern;

public class JacksonAdapter
implements SerializerAdapter {
    private static final Pattern PATTERN = Pattern.compile("^\"*|\"*$");
    private static final String MUTABLE_COERCION_CONFIG = "com.fasterxml.jackson.databind.cfg.MutableCoercionConfig";
    private static final String COERCION_INPUT_SHAPE = "com.fasterxml.jackson.databind.cfg.CoercionInputShape";
    private static final String COERCION_ACTION = "com.fasterxml.jackson.databind.cfg.CoercionAction";
    private static final MethodHandle COERCION_CONFIG_DEFAULTS;
    private static final MethodHandle SET_COERCION;
    private static final Object COERCION_INPUT_SHAPE_EMPTY_STRING;
    private static final Object COERCION_ACTION_AS_NULL;
    private static final boolean USE_REFLECTION_TO_SET_COERCION;
    private final ClientLogger logger = new ClientLogger(JacksonAdapter.class);
    private final ObjectMapper mapper;
    private final ObjectMapper simpleMapper = JacksonAdapter.initializeMapperBuilder(JsonMapper.builder()).build();
    private final ObjectMapper xmlMapper;
    private final ObjectMapper headerMapper = ((JsonMapper.Builder)JacksonAdapter.initializeMapperBuilder(JsonMapper.builder()).enable(new MapperFeature[]{MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES})).build();
    private static SerializerAdapter serializerAdapter;
    private static final int CACHE_SIZE_LIMIT = 10000;
    private static final Map<Type, JavaType> TYPE_TO_JAVA_TYPE_CACHE;
    private static final Map<Field, MethodHandle> FIELD_TO_SETTER_CACHE;

    public JacksonAdapter() {
        this.xmlMapper = JacksonAdapter.initializeMapperBuilder(XmlMapper.builder()).defaultUseWrapper(false).enable(new ToXmlGenerator.Feature[]{ToXmlGenerator.Feature.WRITE_XML_DECLARATION}).enable(new FromXmlParser.Feature[]{FromXmlParser.Feature.EMPTY_ELEMENT_AS_NULL}).build();
        if (USE_REFLECTION_TO_SET_COERCION) {
            try {
                Object object = COERCION_CONFIG_DEFAULTS.invoke(this.xmlMapper);
                SET_COERCION.invoke(object, COERCION_INPUT_SHAPE_EMPTY_STRING, COERCION_ACTION_AS_NULL);
            }
            catch (Throwable e) {
                this.logger.verbose("Failed to set coercion actions.", e);
            }
        } else {
            this.logger.verbose("Didn't set coercion defaults as it wasn't found on the classpath.");
        }
        ObjectMapper flatteningMapper = ((JsonMapper.Builder)((JsonMapper.Builder)JacksonAdapter.initializeMapperBuilder(JsonMapper.builder()).addModule((Module)FlatteningSerializer.getModule(this.simpleMapper()))).addModule((Module)FlatteningDeserializer.getModule(this.simpleMapper()))).build();
        this.mapper = ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JacksonAdapter.initializeMapperBuilder(JsonMapper.builder()).addModule((Module)AdditionalPropertiesSerializer.getModule(flatteningMapper))).addModule((Module)AdditionalPropertiesDeserializer.getModule(flatteningMapper))).addModule((Module)FlatteningSerializer.getModule(this.simpleMapper()))).addModule((Module)FlatteningDeserializer.getModule(this.simpleMapper()))).build();
    }

    protected ObjectMapper simpleMapper() {
        return this.simpleMapper;
    }

    public static synchronized SerializerAdapter createDefaultSerializerAdapter() {
        if (serializerAdapter == null) {
            serializerAdapter = new JacksonAdapter();
        }
        return serializerAdapter;
    }

    public ObjectMapper serializer() {
        return this.mapper;
    }

    @Override
    public String serialize(Object object, SerializerEncoding encoding) throws IOException {
        if (object == null) {
            return null;
        }
        if (encoding == SerializerEncoding.XML) {
            return this.xmlMapper.writeValueAsString(object);
        }
        return this.serializer().writeValueAsString(object);
    }

    @Override
    public byte[] serializeToBytes(Object object, SerializerEncoding encoding) throws IOException {
        if (object == null) {
            return null;
        }
        if (encoding == SerializerEncoding.XML) {
            return this.xmlMapper.writeValueAsBytes(object);
        }
        return this.serializer().writeValueAsBytes(object);
    }

    @Override
    public void serialize(Object object, SerializerEncoding encoding, OutputStream outputStream) throws IOException {
        if (object == null) {
            return;
        }
        if (encoding == SerializerEncoding.XML) {
            this.xmlMapper.writeValue(outputStream, object);
        } else {
            this.serializer().writeValue(outputStream, object);
        }
    }

    @Override
    public String serializeRaw(Object object) {
        if (object == null) {
            return null;
        }
        try {
            return PATTERN.matcher(this.serialize(object, SerializerEncoding.JSON)).replaceAll("");
        }
        catch (IOException ex) {
            this.logger.warning("Failed to serialize {} to JSON.", object.getClass(), ex);
            return null;
        }
    }

    @Override
    public String serializeList(List<?> list, CollectionFormat format) {
        return this.serializeIterable(list, format);
    }

    @Override
    public <T> T deserialize(String value, Type type, SerializerEncoding encoding) throws IOException {
        if (CoreUtils.isNullOrEmpty(value)) {
            return null;
        }
        JavaType javaType = this.createJavaType(type);
        if (encoding == SerializerEncoding.XML) {
            return (T)this.xmlMapper.readValue(value, javaType);
        }
        return (T)this.serializer().readValue(value, javaType);
    }

    @Override
    public <T> T deserialize(byte[] bytes, Type type, SerializerEncoding encoding) throws IOException {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        JavaType javaType = this.createJavaType(type);
        if (encoding == SerializerEncoding.XML) {
            return (T)this.xmlMapper.readValue(bytes, javaType);
        }
        return (T)this.serializer().readValue(bytes, javaType);
    }

    @Override
    public <T> T deserialize(InputStream inputStream, Type type, SerializerEncoding encoding) throws IOException {
        if (inputStream == null) {
            return null;
        }
        JavaType javaType = this.createJavaType(type);
        if (encoding == SerializerEncoding.XML) {
            return (T)this.xmlMapper.readValue(inputStream, javaType);
        }
        return (T)this.serializer().readValue(inputStream, javaType);
    }

    @Override
    public <T> T deserialize(HttpHeaders headers, Type deserializedHeadersType) throws IOException {
        if (deserializedHeadersType == null) {
            return null;
        }
        Object deserializedHeaders = this.headerMapper.convertValue((Object)headers, this.createJavaType(deserializedHeadersType));
        Class<?> deserializedHeadersClass = TypeUtil.getRawClass(deserializedHeadersType);
        Field[] declaredFields = deserializedHeadersClass.getDeclaredFields();
        ArrayList<HeaderCollectionHandler> headerCollectionHandlers = new ArrayList<HeaderCollectionHandler>();
        HashSet<Character> headerCollectionsFirstCharacters = new HashSet<Character>();
        for (Field declaredField : declaredFields) {
            HeaderCollection headerCollectionAnnotation;
            String headerCollectionPrefix;
            int headerCollectionPrefixLength;
            Type[] mapTypeArguments;
            if (!declaredField.isAnnotationPresent(HeaderCollection.class)) continue;
            Type declaredFieldType = declaredField.getGenericType();
            if (!TypeUtil.isTypeOrSubTypeOf(declaredField.getType(), Map.class) || (mapTypeArguments = TypeUtil.getTypeArguments(declaredFieldType)).length != 2 || mapTypeArguments[0] != String.class || mapTypeArguments[1] != String.class || (headerCollectionPrefixLength = (headerCollectionPrefix = (headerCollectionAnnotation = declaredField.getAnnotation(HeaderCollection.class)).value().toLowerCase(Locale.ROOT)).length()) == 0) continue;
            headerCollectionHandlers.add(new HeaderCollectionHandler(headerCollectionPrefix, declaredField));
            headerCollectionsFirstCharacters.add(Character.valueOf(headerCollectionPrefix.charAt(0)));
        }
        for (HttpHeader header : headers) {
            String headerNameLower = header.getName().toLowerCase(Locale.ROOT);
            if (!headerCollectionsFirstCharacters.contains(Character.valueOf(headerNameLower.charAt(0)))) continue;
            for (HeaderCollectionHandler headerCollectionHandler : headerCollectionHandlers) {
                if (!headerCollectionHandler.headerStartsWithPrefix(headerNameLower)) continue;
                headerCollectionHandler.addHeader(header.getName(), header.getValue());
            }
        }
        headerCollectionHandlers.forEach(h -> h.injectValuesIntoDeclaringField(deserializedHeaders, this.logger));
        return (T)deserializedHeaders;
    }

    private static <S extends MapperBuilder<?, ?>> S initializeMapperBuilder(S mapper) {
        mapper.enable(new SerializationFeature[]{SerializationFeature.WRITE_EMPTY_JSON_ARRAYS}).enable(new DeserializationFeature[]{DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT}).enable(new DeserializationFeature[]{DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY}).disable(new SerializationFeature[]{SerializationFeature.WRITE_DATES_AS_TIMESTAMPS}).disable(new SerializationFeature[]{SerializationFeature.FAIL_ON_EMPTY_BEANS}).disable(new DeserializationFeature[]{DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES}).serializationInclusion(JsonInclude.Include.NON_NULL).addModule((Module)new JavaTimeModule()).addModule((Module)ByteArraySerializer.getModule()).addModule((Module)Base64UrlSerializer.getModule()).addModule((Module)DateTimeSerializer.getModule()).addModule((Module)DateTimeDeserializer.getModule()).addModule((Module)DateTimeRfc1123Serializer.getModule()).addModule((Module)DurationSerializer.getModule()).addModule((Module)HttpHeadersSerializer.getModule()).addModule((Module)UnixTimeSerializer.getModule()).addModule((Module)UnixTimeDeserializer.getModule()).addModule((Module)GeoJsonSerializer.getModule()).addModule((Module)GeoJsonDeserializer.getModule()).visibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY).visibility(PropertyAccessor.SETTER, JsonAutoDetect.Visibility.NONE).visibility(PropertyAccessor.GETTER, JsonAutoDetect.Visibility.NONE).visibility(PropertyAccessor.IS_GETTER, JsonAutoDetect.Visibility.NONE);
        return mapper;
    }

    private JavaType createJavaType(Type type) {
        if (type == null) {
            return null;
        }
        if (type instanceof JavaType) {
            return (JavaType)type;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
            JavaType[] javaTypeArguments = new JavaType[actualTypeArguments.length];
            for (int i = 0; i != actualTypeArguments.length; ++i) {
                javaTypeArguments[i] = this.createJavaType(actualTypeArguments[i]);
            }
            return JacksonAdapter.getFromCache(type, TYPE_TO_JAVA_TYPE_CACHE, t -> this.mapper.getTypeFactory().constructParametricType((Class)parameterizedType.getRawType(), javaTypeArguments));
        }
        return JacksonAdapter.getFromCache(type, TYPE_TO_JAVA_TYPE_CACHE, t -> this.mapper.getTypeFactory().constructType(t));
    }

    private static <K, V> V getFromCache(K key, Map<K, V> cache, Function<K, V> compute) {
        if (cache.size() >= 10000) {
            cache.clear();
        }
        return cache.computeIfAbsent(key, compute);
    }

    static {
        MethodHandles.Lookup publicLookup = MethodHandles.publicLookup();
        MethodHandle coercionConfigDefaults = null;
        MethodHandle setCoercion = null;
        Object coercionInputShapeEmptyString = null;
        Object coercionActionAsNull = null;
        boolean useReflectionToSetCoercion = false;
        try {
            Class<?> mutableCoercionConfig = Class.forName(MUTABLE_COERCION_CONFIG);
            Class<?> coercionInputShapeClass = Class.forName(COERCION_INPUT_SHAPE);
            Class<?> coercionActionClass = Class.forName(COERCION_ACTION);
            coercionConfigDefaults = publicLookup.findVirtual(ObjectMapper.class, "coercionConfigDefaults", MethodType.methodType(mutableCoercionConfig));
            setCoercion = publicLookup.findVirtual(mutableCoercionConfig, "setCoercion", MethodType.methodType(mutableCoercionConfig, coercionInputShapeClass, coercionActionClass));
            coercionInputShapeEmptyString = publicLookup.findStaticGetter(coercionInputShapeClass, "EmptyString", coercionInputShapeClass).invoke();
            coercionActionAsNull = publicLookup.findStaticGetter(coercionActionClass, "AsNull", coercionActionClass).invoke();
            useReflectionToSetCoercion = true;
        }
        catch (Throwable ex) {
            new ClientLogger(JacksonAdapter.class).verbose("Failed to retrieve MethodHandles used to set coercion configurations. Setting coercion configurations will be skipped.", ex);
        }
        COERCION_CONFIG_DEFAULTS = coercionConfigDefaults;
        SET_COERCION = setCoercion;
        COERCION_INPUT_SHAPE_EMPTY_STRING = coercionInputShapeEmptyString;
        COERCION_ACTION_AS_NULL = coercionActionAsNull;
        USE_REFLECTION_TO_SET_COERCION = useReflectionToSetCoercion;
        TYPE_TO_JAVA_TYPE_CACHE = new ConcurrentHashMap<Type, JavaType>();
        FIELD_TO_SETTER_CACHE = new ConcurrentHashMap<Field, MethodHandle>();
    }

    private static final class HeaderCollectionHandler {
        private final String prefix;
        private final int prefixLength;
        private final Map<String, String> values;
        private final Field declaringField;

        HeaderCollectionHandler(String prefix, Field declaringField) {
            this.prefix = prefix;
            this.prefixLength = prefix.length();
            this.values = new HashMap<String, String>();
            this.declaringField = declaringField;
        }

        boolean headerStartsWithPrefix(String headerName) {
            return headerName.startsWith(this.prefix);
        }

        void addHeader(String headerName, String headerValue) {
            this.values.put(headerName.substring(this.prefixLength), headerValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void injectValuesIntoDeclaringField(Object deserializedHeaders, ClientLogger logger) {
            if (this.usePublicSetter(deserializedHeaders, logger)) {
                return;
            }
            boolean declaredFieldAccessibleBackup = this.declaringField.isAccessible();
            try {
                if (!declaredFieldAccessibleBackup) {
                    AccessController.doPrivileged(() -> {
                        this.declaringField.setAccessible(true);
                        return null;
                    });
                }
                this.declaringField.set(deserializedHeaders, this.values);
                logger.verbose("Set header collection by accessing the field directly.");
            }
            catch (IllegalAccessException ex) {
                logger.warning("Failed to inject header collection values into deserialized headers.", ex);
            }
            finally {
                if (!declaredFieldAccessibleBackup) {
                    AccessController.doPrivileged(() -> {
                        this.declaringField.setAccessible(false);
                        return null;
                    });
                }
            }
        }

        private boolean usePublicSetter(Object deserializedHeaders, ClientLogger logger) {
            Class<?> clazz = deserializedHeaders.getClass();
            String clazzSimpleName = clazz.getSimpleName();
            String fieldName = this.declaringField.getName();
            MethodHandle setterHandler = (MethodHandle)JacksonAdapter.getFromCache(this.declaringField, FIELD_TO_SETTER_CACHE, field -> {
                MethodHandles.Lookup lookupToUse;
                try {
                    lookupToUse = ReflectionUtils.getLookupToUse(clazz);
                }
                catch (Throwable t) {
                    logger.verbose("Failed to retrieve MethodHandles.Lookup for field {}.", field, t);
                    return null;
                }
                String setterName = HeaderCollectionHandler.getPotentialSetterName(fieldName);
                try {
                    MethodHandle handle = lookupToUse.findVirtual(clazz, setterName, MethodType.methodType(clazz, Map.class));
                    logger.verbose("Using MethodHandle for setter {} on class {}.", setterName, clazzSimpleName);
                    return handle;
                }
                catch (ReflectiveOperationException ex) {
                    logger.verbose("Failed to retrieve MethodHandle for setter {} on class {}.", setterName, clazzSimpleName, ex);
                    try {
                        Method setterMethod = deserializedHeaders.getClass().getDeclaredMethod(setterName, Map.class);
                        MethodHandle handle = lookupToUse.unreflect(setterMethod);
                        logger.verbose("Using unreflected MethodHandle for setter {} on class {}.", setterName, clazzSimpleName);
                        return handle;
                    }
                    catch (ReflectiveOperationException ex2) {
                        logger.verbose("Failed to unreflect MethodHandle for setter {} on class {}.", setterName, clazzSimpleName, ex2);
                        return null;
                    }
                }
            });
            if (setterHandler == null) {
                return false;
            }
            try {
                setterHandler.invokeWithArguments(deserializedHeaders, this.values);
                logger.verbose("Set header collection {} on class {} using MethodHandle.", fieldName, clazzSimpleName);
                return true;
            }
            catch (Throwable ex) {
                logger.verbose("Failed to set header {} collection on class {} using MethodHandle.", fieldName, clazzSimpleName, ex);
                return false;
            }
        }

        private static String getPotentialSetterName(String fieldName) {
            return "set" + fieldName.substring(0, 1).toUpperCase(Locale.ROOT) + fieldName.substring(1);
        }
    }
}

